/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.tests.demo;

import io.nflow.engine.service.WorkflowInstanceInclude;
import io.nflow.engine.service.WorkflowInstanceService;
import io.nflow.engine.workflow.curated.BulkWorkflow;
import io.nflow.engine.workflow.executor.WorkflowLogContextListener;
import io.nflow.engine.workflow.instance.WorkflowInstance;
import io.nflow.engine.workflow.instance.WorkflowInstanceAction;
import io.nflow.engine.workflow.instance.WorkflowInstanceFactory;
import io.nflow.jetty.StartNflow;
import io.nflow.metrics.NflowMetricsContext;
import io.nflow.tests.demo.SpringApplicationContext;
import io.nflow.tests.demo.workflow.DemoWorkflow;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Optional;
import org.joda.time.DateTime;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

public class DemoServer {
    public static void main(String[] args) throws Exception {
        new StartNflow().registerSpringContext(NflowMetricsContext.class, SpringApplicationContext.class, DemoServerWorkflowsConfiguration.class).startJetty(7500, "local", "jmx");
        DemoServer.insertDemoWorkflows();
    }

    private static void insertDemoWorkflows() {
        WorkflowInstanceService workflowInstanceService = SpringApplicationContext.applicationContext.getBean(WorkflowInstanceService.class);
        WorkflowInstanceFactory workflowInstanceFactory = SpringApplicationContext.applicationContext.getBean(WorkflowInstanceFactory.class);
        WorkflowInstance instance = new WorkflowInstance.Builder().setType("demo").setState(DemoWorkflow.State.begin.name()).build();
        long id = workflowInstanceService.insertWorkflowInstance(instance);
        instance = workflowInstanceService.getWorkflowInstance(id, Collections.emptySet(), null);
        WorkflowInstanceAction action = new WorkflowInstanceAction.Builder(instance).setType(WorkflowInstanceAction.WorkflowActionType.externalChange).setExecutionEnd(DateTime.now()).build();
        workflowInstanceService.updateWorkflowInstance(instance, action);
        instance = workflowInstanceService.getWorkflowInstance(id, EnumSet.of(WorkflowInstanceInclude.ACTIONS), 1L);
        long actionId = instance.actions.get((int)0).id;
        WorkflowInstance child = new WorkflowInstance.Builder().setType("demo").setState(DemoWorkflow.State.begin.name()).setParentActionId(actionId).setParentWorkflowId(id).build();
        workflowInstanceService.insertWorkflowInstance(child);
        instance = new WorkflowInstance.Builder().setType("slowWorkflow").setSignal(Optional.of(1)).setNextActivation(null).build();
        workflowInstanceService.insertWorkflowInstance(instance);
        instance = workflowInstanceFactory.newWorkflowInstanceBuilder().setType("demoBulk").setState(BulkWorkflow.State.splitWork.name()).putStateVariable("concurrency", 2).putStateVariable("childData", Arrays.asList(1, 2, 3, 4, 5)).build();
        workflowInstanceService.insertWorkflowInstance(instance);
        instance = new WorkflowInstance.Builder().setType("foreverWaiting").build();
        workflowInstanceService.insertWorkflowInstance(instance);
    }

    @Configuration
    @ComponentScan(value={"io.nflow.tests.demo.workflow"})
    static class DemoServerWorkflowsConfiguration {
        DemoServerWorkflowsConfiguration() {
        }

        @Bean
        public WorkflowLogContextListener logContextListener() {
            return new WorkflowLogContextListener("context");
        }
    }
}

