/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.server.spring;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.support.ResourcePropertySource;

public class NflowStandardEnvironment
extends StandardEnvironment {
    private static final Logger logger = LoggerFactory.getLogger(NflowStandardEnvironment.class);

    public NflowStandardEnvironment(Map<String, Object> overrideProperties) {
        this.getPropertySources().addFirst(new MapPropertySource("override", overrideProperties));
        this.addExternalPropertyResource();
        String env = this.getProperty("env", "local");
        this.addActiveProfile(env);
        this.addPropertyResource(env);
        this.addPropertyResource("common");
        this.addPropertyResource("nflow-server");
        String profiles = this.getProperty("profiles", String.class, "");
        for (String profile2 : profiles.split(",")) {
            if (profile2.trim().isEmpty()) continue;
            this.addActiveProfile(profile2);
        }
        this.setupDbProfile();
    }

    private void setupDbProfile() {
        Object[] activeProfiles;
        boolean dbProfileDefined = false;
        for (String string : activeProfiles = this.getActiveProfiles()) {
            if (!string.startsWith("nflow.db")) continue;
            if (dbProfileDefined) {
                throw new RuntimeException("Multiple nflow.db profiles defined: " + Arrays.toString(activeProfiles));
            }
            dbProfileDefined = true;
        }
        if (!dbProfileDefined) {
            this.addActiveProfile("nflow.db.h2");
        }
    }

    private void addExternalPropertyResource() {
        String externalLocation = this.getProperty("nflow.external.config");
        if (!StringUtils.isEmpty(externalLocation)) {
            try {
                this.getPropertySources().addLast(new ResourcePropertySource(externalLocation));
                logger.info("Using external configuration file: {}", (Object)externalLocation);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to initialize external properties from location " + externalLocation, e);
            }
        }
    }

    private void addPropertyResource(String name) {
        name = name + ".properties";
        try {
            this.getPropertySources().addLast(new ResourcePropertySource(name, this.getClass().getClassLoader()));
        }
        catch (IOException e) {
            logger.info("Failed to initialize environment-specific properties from resource {}", (Object)name);
        }
    }
}

