/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.rest.v1.msg;

import com.fasterxml.jackson.annotation.JsonInclude;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.nflow.engine.model.ModelObject;
import io.nflow.rest.v1.msg.Action;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

@ApiModel(description="Basic information of workflow instance")
@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="jackson reads dto fields")
public class ListWorkflowInstanceResponse
extends ModelObject {
    @ApiModelProperty(value="Identifier of the workflow instance", required=true)
    public long id;
    @ApiModelProperty(value="Workflow instance status (created, executing, inProgress, finished, manual)", required=true)
    public String status;
    @ApiModelProperty(value="Workflow definition type", required=true)
    public String type;
    @ApiModelProperty(value="Workflow instance priority. Larger value gets (unfair) priority in scheduling. Defaults to 0 and can be negative.", required=true)
    public Short priority;
    @ApiModelProperty(value="Parent workflow instance id for child workflows")
    public Long parentWorkflowId;
    @ApiModelProperty(value="Parent workflow instance action id for child workflows (action that created the child workflow)")
    public Long parentActionId;
    @ApiModelProperty(value="Main business key or identifier for the workflow instance")
    public String businessKey;
    @ApiModelProperty(value="Unique external identifier within a workflow type. Generated by nflow if not given.", required=true)
    public String externalId;
    @ApiModelProperty(value="State of the workflow instance", required=true)
    public String state;
    @ApiModelProperty(value="Text of describing the reason for state (free text)")
    public String stateText;
    @ApiModelProperty(value="Time when the workflow instance is processed again")
    public DateTime nextActivation;
    @ApiModelProperty(value="State variables for current state")
    public Map<String, Object> stateVariables;
    @ApiModelProperty(value="Number of times the current state has been retried", required=true)
    public int retries;
    @ApiModelProperty(value="Action history of the workflow instance")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Action> actions;
    @ApiModelProperty(value="Workflow instance creation timestamp", required=true)
    public DateTime created;
    @ApiModelProperty(value="Workflow instance latest modification timestamp", required=true)
    public DateTime modified;
    @ApiModelProperty(value="Time when workflow processing started (=start time of the first action)")
    public DateTime started;
    @ApiModelProperty(value="Child workflow instance IDs created by this instance, grouped by instance action ID")
    public Map<Long, List<Long>> childWorkflows;
    @ApiModelProperty(value="Current signal value")
    public Integer signal;
}

