/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.rest.v1.jaxrs;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.nflow.engine.internal.dao.WorkflowInstanceDao;
import io.nflow.engine.service.WorkflowInstanceInclude;
import io.nflow.engine.service.WorkflowInstanceService;
import io.nflow.engine.workflow.instance.WorkflowInstance;
import io.nflow.engine.workflow.instance.WorkflowInstanceAction;
import io.nflow.engine.workflow.instance.WorkflowInstanceFactory;
import io.nflow.rest.config.jaxrs.NflowCors;
import io.nflow.rest.v1.converter.CreateWorkflowConverter;
import io.nflow.rest.v1.converter.ListWorkflowInstanceConverter;
import io.nflow.rest.v1.jaxrs.JaxRsResource;
import io.nflow.rest.v1.msg.CreateWorkflowInstanceRequest;
import io.nflow.rest.v1.msg.CreateWorkflowInstanceResponse;
import io.nflow.rest.v1.msg.ListWorkflowInstanceResponse;
import io.nflow.rest.v1.msg.SetSignalRequest;
import io.nflow.rest.v1.msg.SetSignalResponse;
import io.nflow.rest.v1.msg.UpdateWorkflowInstanceRequest;
import io.nflow.rest.v1.msg.WakeupRequest;
import io.nflow.rest.v1.msg.WakeupResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.stereotype.Component;

@Path(value="/v1/workflow-instance")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(value="nFlow workflow instance management")
@Component
@NflowCors
public class WorkflowInstanceResource
extends JaxRsResource {
    private final WorkflowInstanceService workflowInstances;
    private final CreateWorkflowConverter createWorkflowConverter;
    private final ListWorkflowInstanceConverter listWorkflowConverter;
    private final WorkflowInstanceFactory workflowInstanceFactory;
    private final WorkflowInstanceDao workflowInstanceDao;

    @Inject
    public WorkflowInstanceResource(WorkflowInstanceService workflowInstances, CreateWorkflowConverter createWorkflowConverter, ListWorkflowInstanceConverter listWorkflowConverter, WorkflowInstanceFactory workflowInstanceFactory, WorkflowInstanceDao workflowInstanceDao) {
        this.workflowInstances = workflowInstances;
        this.createWorkflowConverter = createWorkflowConverter;
        this.listWorkflowConverter = listWorkflowConverter;
        this.workflowInstanceFactory = workflowInstanceFactory;
        this.workflowInstanceDao = workflowInstanceDao;
    }

    @OPTIONS
    @Path(value="{any: .*}")
    @ApiOperation(value="CORS preflight handling")
    @Consumes(value={"*/*"})
    public Response corsPreflight() {
        return Response.ok().build();
    }

    @PUT
    @ApiOperation(value="Submit new workflow instance")
    @ApiResponses(value={@ApiResponse(code=201, message="Workflow was created", response=CreateWorkflowInstanceResponse.class), @ApiResponse(code=400, message="If instance could not be created, for example when state variable value was too long")})
    public Response createWorkflowInstance(@Valid @ApiParam(value="Submitted workflow instance information", required=true) CreateWorkflowInstanceRequest req) {
        return this.handleExceptions(() -> {
            WorkflowInstance instance = this.createWorkflowConverter.convert(req);
            long id = this.workflowInstances.insertWorkflowInstance(instance);
            instance = this.workflowInstances.getWorkflowInstance(id, EnumSet.of(WorkflowInstanceInclude.CURRENT_STATE_VARIABLES), null);
            return Response.created(URI.create(String.valueOf(id))).entity(this.createWorkflowConverter.convert(instance));
        });
    }

    @PUT
    @Path(value="/id/{id}")
    @ApiOperation(value="Update workflow instance", notes="The service is typically used in manual state transition via nFlow Explorer or a business UI.")
    @ApiResponses(value={@ApiResponse(code=204, message="If update was successful"), @ApiResponse(code=400, message="If instance could not be updated, for example when state variable value was too long"), @ApiResponse(code=409, message="If workflow was executing and no update was done")})
    public Response updateWorkflowInstance(@ApiParam(value="Internal id for workflow instance") @PathParam(value="id") long id, @ApiParam(value="Submitted workflow instance information") UpdateWorkflowInstanceRequest req) {
        return this.handleExceptions(() -> {
            boolean updated = super.updateWorkflowInstance(id, req, this.workflowInstanceFactory, this.workflowInstances, this.workflowInstanceDao);
            return updated ? Response.noContent() : Response.status(Response.Status.CONFLICT);
        });
    }

    @GET
    @Path(value="/id/{id}")
    @ApiOperation(value="Fetch a workflow instance", notes="Fetch full state and action history of a single workflow instance.")
    @ApiResponses(value={@ApiResponse(code=200, response=ListWorkflowInstanceResponse.class, message="If instance was found"), @ApiResponse(code=404, message="If instance was not found")})
    @SuppressFBWarnings(value={"LEST_LOST_EXCEPTION_STACK_TRACE"}, justification="The empty result exception contains no useful information")
    public Response fetchWorkflowInstance(@ApiParam(value="Internal id for workflow instance") @PathParam(value="id") long id, @QueryParam(value="include") @ApiParam(value="Data to include in response. currentStateVariables = current stateVariables for worfklow, actions = state transitions, actionStateVariables = state variable changes for actions, childWorkflows = map of created child workflow instance IDs by action ID", allowableValues="currentStateVariables,actions,actionStateVariables,childWorkflows", allowMultiple=true) String include, @QueryParam(value="maxActions") @ApiParam(value="Maximum number of actions returned for each workflow instance") Long maxActions) {
        return this.handleExceptions(() -> Response.ok(super.fetchWorkflowInstance(id, include, maxActions, this.workflowInstances, this.listWorkflowConverter)));
    }

    @GET
    @ApiOperation(value="List workflow instances", response=ListWorkflowInstanceResponse.class, responseContainer="List")
    public Response listWorkflowInstances(@QueryParam(value="id") @ApiParam(value="Internal id of workflow instance") List<Long> ids, @QueryParam(value="type") @ApiParam(value="Workflow definition type of workflow instance") List<String> types, @QueryParam(value="parentWorkflowId") @ApiParam(value="Id of parent workflow instance") Long parentWorkflowId, @QueryParam(value="parentActionId") @ApiParam(value="Id of parent workflow instance action") Long parentActionId, @QueryParam(value="state") @ApiParam(value="Current state of workflow instance") List<String> states, @QueryParam(value="status") @ApiParam(value="Current status of workflow instance") List<WorkflowInstance.WorkflowInstanceStatus> statuses, @QueryParam(value="businessKey") @ApiParam(value="Business key for workflow instance") String businessKey, @QueryParam(value="externalId") @ApiParam(value="External id for workflow instance") String externalId, @QueryParam(value="stateVariableKey") @ApiParam(value="Key of state variable that must exist for workflow instance") String stateVariableKey, @QueryParam(value="stateVariableValue") @ApiParam(value="Current value of state variable defined by stateVariableKey") String stateVariableValue, @QueryParam(value="include") @ApiParam(value="Data to include in response. currentStateVariables = current stateVariables for worfklow, actions = state transitions, actionStateVariables = state variable changes for actions, childWorkflows = map of created child workflow instance IDs by action ID", allowableValues="currentStateVariables,actions,actionStateVariables,childWorkflows", allowMultiple=true) String include, @QueryParam(value="maxResults") @ApiParam(value="Maximum number of workflow instances to be returned") Long maxResults, @QueryParam(value="maxActions") @ApiParam(value="Maximum number of actions returned for each workflow instance") Long maxActions) {
        return this.handleExceptions(() -> Response.ok(super.listWorkflowInstances(ids, types, parentWorkflowId, parentActionId, states, statuses, businessKey, externalId, stateVariableKey, stateVariableValue, include, maxResults, maxActions, this.workflowInstances, this.listWorkflowConverter).iterator()));
    }

    @PUT
    @Path(value="/{id}/signal")
    @ApiOperation(value="Set workflow instance signal value", response=SetSignalResponse.class, notes="The service may be used for example to interrupt executing workflow instance.")
    public Response setSignal(@ApiParam(value="Internal id for workflow instance") @PathParam(value="id") long id, @Valid @ApiParam(value="New signal value") SetSignalRequest req) {
        return this.handleExceptions(() -> {
            SetSignalResponse response = new SetSignalResponse();
            response.setSignalSuccess = this.workflowInstances.setSignal(id, Optional.ofNullable(req.signal), req.reason, WorkflowInstanceAction.WorkflowActionType.externalChange);
            return Response.ok(response);
        });
    }

    @PUT
    @Path(value="/{id}/wakeup")
    @ApiOperation(value="Wake up sleeping workflow instance", response=WakeupResponse.class, notes="If expected states are given, only wake up if the instance is in one of the expected states.")
    public Response wakeup(@ApiParam(value="Internal id for workflow instance") @PathParam(value="id") long id, @Valid @ApiParam(value="Expected states") WakeupRequest req) {
        return this.handleExceptions(() -> {
            WakeupResponse response = new WakeupResponse();
            List expectedStates = Optional.ofNullable(req.expectedStates).orElseGet(Collections::emptyList);
            response.wakeupSuccess = this.workflowInstances.wakeupWorkflowInstance(id, expectedStates);
            return Response.ok(response);
        });
    }
}

