/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.rest.v1.jaxrs;

import io.nflow.engine.service.WorkflowExecutorService;
import io.nflow.rest.config.jaxrs.NflowCors;
import io.nflow.rest.v1.converter.ListWorkflowExecutorConverter;
import io.nflow.rest.v1.jaxrs.JaxRsResource;
import io.nflow.rest.v1.msg.ListWorkflowExecutorResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.stereotype.Component;

@Path(value="/v1/workflow-executor")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(value="nFlow workflow executor management")
@Component
@NflowCors
public class WorkflowExecutorResource
extends JaxRsResource {
    private final WorkflowExecutorService workflowExecutors;
    private final ListWorkflowExecutorConverter converter;

    @Inject
    public WorkflowExecutorResource(WorkflowExecutorService workflowExecutors, ListWorkflowExecutorConverter converter) {
        this.workflowExecutors = workflowExecutors;
        this.converter = converter;
    }

    @GET
    @ApiOperation(value="List workflow executors", response=ListWorkflowExecutorResponse.class, responseContainer="List")
    public Response listWorkflowExecutors() {
        return this.handleExceptions(() -> Response.ok(this.workflowExecutors.getWorkflowExecutors().stream().map(this.converter::convert).collect(Collectors.toList())));
    }
}

