/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.rest.v1.jaxrs;

import io.nflow.engine.internal.dao.WorkflowDefinitionDao;
import io.nflow.engine.service.WorkflowDefinitionService;
import io.nflow.rest.config.jaxrs.NflowCors;
import io.nflow.rest.v1.converter.ListWorkflowDefinitionConverter;
import io.nflow.rest.v1.jaxrs.JaxRsResource;
import io.nflow.rest.v1.msg.ListWorkflowDefinitionResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.stereotype.Component;

@Path(value="/v1/workflow-definition")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(value="nFlow workflow definition management")
@Component
@NflowCors
public class WorkflowDefinitionResource
extends JaxRsResource {
    private final WorkflowDefinitionService workflowDefinitions;
    private final ListWorkflowDefinitionConverter converter;
    private final WorkflowDefinitionDao workflowDefinitionDao;

    @Inject
    public WorkflowDefinitionResource(WorkflowDefinitionService workflowDefinitions, ListWorkflowDefinitionConverter converter, WorkflowDefinitionDao workflowDefinitionDao) {
        this.workflowDefinitions = workflowDefinitions;
        this.converter = converter;
        this.workflowDefinitionDao = workflowDefinitionDao;
    }

    @GET
    @ApiOperation(value="List workflow definitions", response=ListWorkflowDefinitionResponse.class, responseContainer="List", notes="Returns workflow definition(s): all possible states, transitions between states and other setting metadata. The workflow definition can deployed in nFlow engine or historical workflow definition stored in the database.")
    public Response listWorkflowDefinitions(@QueryParam(value="type") @ApiParam(value="Included workflow types") List<String> types) {
        return this.handleExceptions(() -> Response.ok(super.listWorkflowDefinitions(types, this.workflowDefinitions, this.converter, this.workflowDefinitionDao)));
    }
}

