/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.rest.v1.jaxrs;

import io.nflow.engine.service.StatisticsService;
import io.nflow.rest.config.jaxrs.NflowCors;
import io.nflow.rest.v1.converter.StatisticsConverter;
import io.nflow.rest.v1.jaxrs.JaxRsResource;
import io.nflow.rest.v1.msg.StatisticsResponse;
import io.nflow.rest.v1.msg.WorkflowDefinitionStatisticsResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.joda.time.DateTime;
import org.springframework.stereotype.Component;

@Path(value="/v1/statistics")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(value="nFlow statistics")
@Component
@NflowCors
public class StatisticsResource
extends JaxRsResource {
    @Inject
    private StatisticsService statisticsService;
    @Inject
    private StatisticsConverter statisticsConverter;

    @GET
    @ApiOperation(value="Get executor group statistics", response=StatisticsResponse.class, notes="Returns counts of queued and executing workflow instances.")
    public Response queryStatistics() {
        return this.handleExceptions(() -> Response.ok(this.statisticsConverter.convert(this.statisticsService.getStatistics())));
    }

    @GET
    @Path(value="/workflow/{type}")
    @ApiOperation(value="Get workflow definition statistics", response=WorkflowDefinitionStatisticsResponse.class)
    public Response getStatistics(@PathParam(value="type") @ApiParam(value="Workflow definition type", required=true) String type, @QueryParam(value="createdAfter") @ApiParam(value="Include only workflow instances created after given time") DateTime createdAfter, @QueryParam(value="createdBefore") @ApiParam(value="Include only workflow instances created before given time") DateTime createdBefore, @QueryParam(value="modifiedAfter") @ApiParam(value="Include only workflow instances modified after given time") DateTime modifiedAfter, @QueryParam(value="modifiedBefore") @ApiParam(value="Include only workflow instances modified before given time") DateTime modifiedBefore) {
        return this.handleExceptions(() -> Response.ok(this.statisticsConverter.convert(this.statisticsService.getWorkflowDefinitionStatistics(type, createdAfter, createdBefore, modifiedAfter, modifiedBefore))));
    }
}

