/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.rest.v1.converter;

import io.nflow.engine.service.MaintenanceConfiguration;
import io.nflow.engine.service.MaintenanceResults;
import io.nflow.rest.v1.msg.MaintenanceRequest;
import io.nflow.rest.v1.msg.MaintenanceResponse;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Supplier;
import org.springframework.stereotype.Component;

@Component
public class MaintenanceConverter {
    public MaintenanceConfiguration convert(MaintenanceRequest request) {
        MaintenanceConfiguration.Builder builder = new MaintenanceConfiguration.Builder();
        this.apply(request.archiveWorkflows, builder::withArchiveWorkflows);
        this.apply(request.deleteArchivedWorkflows, builder::withDeleteArchivedWorkflows);
        this.apply(request.deleteWorkflows, builder::withDeleteWorkflows);
        return builder.build();
    }

    private void apply(MaintenanceRequest.MaintenanceRequestItem requestItem, Supplier<MaintenanceConfiguration.ConfigurationItem.Builder> builderSupplier) {
        Optional.ofNullable(requestItem).ifPresent(item -> ((MaintenanceConfiguration.ConfigurationItem.Builder)builderSupplier.get()).setOlderThanPeriod(item.olderThanPeriod).setBatchSize(item.batchSize).setWorkflowTypes(Optional.ofNullable(item.workflowTypes).orElse(Collections.emptySet())).done());
    }

    public MaintenanceResponse convert(MaintenanceResults results) {
        MaintenanceResponse response = new MaintenanceResponse();
        response.archivedWorkflows = results.archivedWorkflows;
        response.deletedArchivedWorkflows = results.deletedArchivedWorkflows;
        response.deletedWorkflows = results.deletedWorkflows;
        return response;
    }
}

