/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.rest.v1.converter;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.nflow.engine.internal.workflow.StoredWorkflowDefinition;
import io.nflow.engine.workflow.definition.AbstractWorkflowDefinition;
import io.nflow.engine.workflow.definition.WorkflowSettings;
import io.nflow.engine.workflow.definition.WorkflowState;
import io.nflow.rest.v1.msg.ListWorkflowDefinitionResponse;
import io.nflow.rest.v1.msg.State;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class ListWorkflowDefinitionConverter {
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="cast is safe")
    public ListWorkflowDefinitionResponse convert(AbstractWorkflowDefinition<? extends WorkflowState> definition) {
        State state;
        ListWorkflowDefinitionResponse resp = new ListWorkflowDefinitionResponse();
        resp.type = definition.getType();
        resp.name = definition.getName();
        resp.description = definition.getDescription();
        resp.onError = definition.getErrorState().name();
        LinkedHashMap<String, State> states = new LinkedHashMap<String, State>(definition.getStates().size() * 2);
        for (WorkflowState workflowState : definition.getStates()) {
            states.put(workflowState.name(), new State(workflowState.name(), workflowState.getType().name(), workflowState.getDescription()));
        }
        for (Map.Entry entry2 : definition.getAllowedTransitions().entrySet()) {
            state = (State)states.get(entry2.getKey());
            for (String targetState : (List)entry2.getValue()) {
                state.transitions.add(targetState);
            }
        }
        for (Map.Entry entry3 : definition.getFailureTransitions().entrySet()) {
            state = (State)states.get(entry3.getKey());
            state.onFailure = ((WorkflowState)entry3.getValue()).name();
        }
        Collection values = states.values();
        resp.states = values.toArray(new State[values.size()]);
        WorkflowSettings workflowSettings = definition.getSettings();
        ListWorkflowDefinitionResponse.TransitionDelays transitionDelays = new ListWorkflowDefinitionResponse.TransitionDelays();
        transitionDelays.immediate = workflowSettings.immediateTransitionDelay;
        transitionDelays.waitShort = workflowSettings.shortTransitionDelay;
        transitionDelays.minErrorWait = workflowSettings.minErrorTransitionDelay;
        transitionDelays.maxErrorWait = workflowSettings.maxErrorTransitionDelay;
        ListWorkflowDefinitionResponse.Settings settings = new ListWorkflowDefinitionResponse.Settings();
        settings.transitionDelaysInMilliseconds = transitionDelays;
        settings.maxRetries = workflowSettings.maxRetries;
        settings.historyDeletableAfter = workflowSettings.historyDeletableAfter;
        settings.defaultPriority = workflowSettings.defaultPriority;
        resp.settings = settings;
        resp.supportedSignals = (ListWorkflowDefinitionResponse.Signal[])definition.getSupportedSignals().entrySet().stream().map(entry -> {
            ListWorkflowDefinitionResponse.Signal signal = new ListWorkflowDefinitionResponse.Signal();
            signal.value = (Integer)entry.getKey();
            signal.description = (String)entry.getValue();
            return signal;
        }).toArray(ListWorkflowDefinitionResponse.Signal[]::new);
        return resp;
    }

    public ListWorkflowDefinitionResponse convert(StoredWorkflowDefinition storedDefinition) {
        ListWorkflowDefinitionResponse resp = new ListWorkflowDefinitionResponse();
        resp.type = storedDefinition.type;
        resp.description = storedDefinition.description;
        resp.onError = storedDefinition.onError;
        ArrayList<State> states = new ArrayList<State>(storedDefinition.states.size());
        for (StoredWorkflowDefinition.State state : storedDefinition.states) {
            State tmp = new State(state.id, state.type, state.description);
            tmp.transitions.addAll(state.transitions);
            tmp.onFailure = state.onFailure;
            states.add(tmp);
        }
        resp.states = states.toArray(new State[states.size()]);
        resp.supportedSignals = (ListWorkflowDefinitionResponse.Signal[])storedDefinition.supportedSignals.stream().map(s2 -> {
            ListWorkflowDefinitionResponse.Signal signal = new ListWorkflowDefinitionResponse.Signal();
            signal.value = s2.value;
            signal.description = s2.description;
            return signal;
        }).toArray(ListWorkflowDefinitionResponse.Signal[]::new);
        return resp;
    }
}

