/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.rest.config.jaxrs;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;

@Provider
public class DateTimeParamConverterProvider
implements ParamConverterProvider {
    @Override
    public <T> ParamConverter<T> getConverter(Class<T> type, Type genericType, Annotation[] annotations) {
        if (type.equals(DateTime.class)) {
            return new DateTimeParamConverter();
        }
        return null;
    }

    static final class DateTimeParamConverter
    implements ParamConverter<DateTime> {
        DateTimeParamConverter() {
        }

        @Override
        public DateTime fromString(String value) {
            if (StringUtils.isEmpty(value)) {
                return null;
            }
            try {
                return ISODateTimeFormat.dateTimeNoMillis().parseDateTime(value);
            }
            catch (IllegalArgumentException e) {
                try {
                    return ISODateTimeFormat.dateTime().parseDateTime(value);
                }
                catch (IllegalArgumentException e2) {
                    throw new BadRequestException(String.format("Unrecognized date format: %s", value), (Throwable)e2);
                }
            }
        }

        @Override
        public String toString(DateTime value) {
            if (value == null) {
                return null;
            }
            return value.toString();
        }
    }
}

