/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.rest.config.jaxrs;

import io.nflow.rest.config.jaxrs.NflowCors;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.springframework.core.env.Environment;

@Provider
@NflowCors
public class CorsHeaderContainerResponseFilter
implements ContainerResponseFilter {
    private final boolean enabled;
    private final String origin;
    private final String headers;

    @Inject
    public CorsHeaderContainerResponseFilter(Environment env) {
        this.enabled = env.getRequiredProperty("nflow.rest.cors.enabled", Boolean.class);
        this.origin = env.getRequiredProperty("nflow.rest.allow.origin");
        this.headers = env.getRequiredProperty("nflow.rest.allow.headers");
    }

    @Override
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        if (this.enabled) {
            MultivaluedMap<String, Object> responseHeaders = responseContext.getHeaders();
            responseHeaders.add("Access-Control-Allow-Origin", this.origin);
            responseHeaders.add("Access-Control-Allow-Headers", this.headers);
            responseHeaders.add("Access-Control-Allow-Methods", "OPTIONS, GET, POST, PUT, DELETE");
            responseHeaders.add("Access-Control-Allow-Credentials", "true");
        }
    }
}

