/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.jetty.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import io.nflow.engine.config.NFlow;
import io.nflow.jetty.config.JmxConfiguration;
import io.nflow.jetty.config.MetricsConfiguration;
import io.nflow.jetty.mapper.CustomValidationExceptionMapper;
import io.nflow.rest.config.RestConfiguration;
import io.nflow.rest.config.jaxrs.CorsHeaderContainerResponseFilter;
import io.nflow.rest.config.jaxrs.DateTimeParamConverterProvider;
import io.nflow.rest.v1.jaxrs.MaintenanceResource;
import io.nflow.rest.v1.jaxrs.StatisticsResource;
import io.nflow.rest.v1.jaxrs.WorkflowDefinitionResource;
import io.nflow.rest.v1.jaxrs.WorkflowExecutorResource;
import io.nflow.rest.v1.jaxrs.WorkflowInstanceResource;
import java.util.Arrays;
import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Named;
import javax.sql.DataSource;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.cxf.bus.spring.SpringBus;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.ext.logging.LoggingFeature;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.impl.WebApplicationExceptionMapper;
import org.apache.cxf.jaxrs.swagger.Swagger2Feature;
import org.apache.cxf.jaxrs.validation.JAXRSBeanValidationInInterceptor;
import org.apache.cxf.jaxrs.validation.JAXRSBeanValidationOutInterceptor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@ComponentScan(value={"io.nflow.jetty"})
@Import(value={RestConfiguration.class, JmxConfiguration.class, MetricsConfiguration.class})
@EnableTransactionManagement
public class NflowJettyConfiguration {
    @Inject
    private Environment env;

    @Bean
    public Server jaxRsServer(WorkflowInstanceResource workflowInstanceResource, WorkflowDefinitionResource workflowDefinitionResource, WorkflowExecutorResource workflowExecutorResource, StatisticsResource statisticsResource, MaintenanceResource maintenanceResource, @Named(value="nflowRestObjectMapper") ObjectMapper nflowRestObjectMapper, JAXRSBeanValidationInInterceptor validationInInterceptor, JAXRSBeanValidationOutInterceptor validationOutInterceptor) {
        JAXRSServerFactoryBean factory = RuntimeDelegate.getInstance().createEndpoint(this.jaxRsApiApplication(), JAXRSServerFactoryBean.class);
        factory.setServiceBeans(Arrays.asList(workflowInstanceResource, workflowDefinitionResource, workflowExecutorResource, statisticsResource, maintenanceResource));
        String factoryAddress = factory.getAddress();
        if (!factoryAddress.startsWith("/")) {
            factory.setAddress('/' + factoryAddress);
        }
        factory.setProviders(Arrays.asList(this.jsonProvider(nflowRestObjectMapper), this.corsHeadersProvider(), new WebApplicationExceptionMapper(), new CustomValidationExceptionMapper(), new DateTimeParamConverterProvider()));
        factory.setFeatures(Arrays.asList(new LoggingFeature(), this.swaggerFeature()));
        factory.setBus(this.cxf());
        factory.setInInterceptors(Collections.singletonList(validationInInterceptor));
        factory.setOutInterceptors(Collections.singletonList(validationOutInterceptor));
        return factory.create();
    }

    @Bean
    public JAXRSBeanValidationInInterceptor validationInInterceptor() {
        return new JAXRSBeanValidationInInterceptor();
    }

    @Bean
    public JAXRSBeanValidationOutInterceptor validationOutInterceptor() {
        return new JAXRSBeanValidationOutInterceptor();
    }

    private Feature swaggerFeature() {
        Swagger2Feature feature = new Swagger2Feature();
        feature.setBasePath("/nflow/api");
        feature.setScan(true);
        feature.setResourcePackage(this.env.getProperty("nflow.swagger.packages", "io.nflow.rest"));
        feature.setContact("nFlow community (nflow-users@googlegroups.com)");
        feature.setDescription("nFlow REST API provides services for managing workflow instances and querying metadata (statistics, workflow definitions, etc) of nFlow Engine. The services are also used by nFlow Explorer user interface.");
        feature.setLicense("European Union Public Licence V. 1.1");
        feature.setLicenseUrl("https://raw.githubusercontent.com/NitorCreations/nflow/master/EUPL-v1.1-Licence.txt");
        feature.setTitle("nflow-rest-api");
        feature.setVersion("1");
        return feature;
    }

    private CorsHeaderContainerResponseFilter corsHeadersProvider() {
        return new CorsHeaderContainerResponseFilter(this.env);
    }

    @Bean
    public JacksonJsonProvider jsonProvider(@Named(value="nflowRestObjectMapper") ObjectMapper nflowRestObjectMapper) {
        return new JacksonJsonProvider(nflowRestObjectMapper);
    }

    @Bean(destroyMethod="shutdown")
    public SpringBus cxf() {
        return new SpringBus();
    }

    @Bean
    public JaxRsApiApplication jaxRsApiApplication() {
        return new JaxRsApiApplication();
    }

    @Bean
    public PlatformTransactionManager transactionManager(@NFlow DataSource nflowDataSource) {
        return new DataSourceTransactionManager(nflowDataSource);
    }

    @ApplicationPath(value="/")
    public static class JaxRsApiApplication
    extends Application {
    }
}

