/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.jetty.config;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.codahale.metrics.health.jvm.ThreadDeadlockHealthCheck;
import com.codahale.metrics.jvm.BufferPoolMetricSet;
import com.codahale.metrics.jvm.CachedThreadStatesGaugeSet;
import com.codahale.metrics.jvm.ClassLoadingGaugeSet;
import com.codahale.metrics.jvm.FileDescriptorRatioGauge;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadDeadlockDetector;
import java.lang.management.ManagementFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MetricsConfiguration {
    @Bean
    public MetricRegistry metricRegistry() {
        return new MetricRegistry();
    }

    @Bean
    public HealthCheckRegistry healthCheckRegistry() {
        return new HealthCheckRegistry();
    }

    @PostConstruct
    public void registerHealthChecks() {
        this.healthCheckRegistry().register("threadDeadlocks", new ThreadDeadlockHealthCheck());
    }

    @PostConstruct
    public void registerMetrics() {
        MetricRegistry registry = this.metricRegistry();
        registry.register("memoryUsage", new MemoryUsageGaugeSet());
        registry.register("bufferPools", new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()));
        registry.register("garbageCollector", new GarbageCollectorMetricSet());
        registry.register("classLoading", new ClassLoadingGaugeSet());
        registry.register("fileDescriptorRatio", new FileDescriptorRatioGauge());
        registry.register("threadStates", new CachedThreadStatesGaugeSet(ManagementFactory.getThreadMXBean(), new ThreadDeadlockDetector(), 60L, TimeUnit.SECONDS));
    }
}

