/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.workflow.instance;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.nflow.engine.internal.workflow.ObjectStringMapper;
import io.nflow.engine.model.ModelObject;
import io.nflow.engine.workflow.instance.WorkflowInstanceAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.joda.time.DateTime;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="used by nflow-rest")
public class WorkflowInstance
extends ModelObject {
    public final Long id;
    public final Integer executorId;
    public final Long parentWorkflowId;
    public final Long parentActionId;
    public final WorkflowInstanceStatus status;
    public final String type;
    public final Short priority;
    public final String businessKey;
    public final String externalId;
    public final String state;
    public final String stateText;
    public final DateTime nextActivation;
    public final Map<String, String> stateVariables;
    public final Map<String, String> originalStateVariables;
    public final List<WorkflowInstanceAction> actions;
    public final int retries;
    public final DateTime created;
    public final DateTime modified;
    public final DateTime started;
    public final String executorGroup;
    public final Optional<Integer> signal;
    public Map<Long, List<Long>> childWorkflows;
    ObjectStringMapper mapper;

    WorkflowInstance(Builder builder) {
        this.id = builder.id;
        this.executorId = builder.executorId;
        this.parentWorkflowId = builder.parentWorkflowId;
        this.parentActionId = builder.parentActionId;
        this.status = builder.status;
        this.type = builder.type;
        this.priority = builder.priority;
        this.businessKey = builder.businessKey;
        this.externalId = builder.externalId;
        this.state = builder.state;
        this.stateText = builder.stateText;
        this.nextActivation = builder.nextActivation;
        this.originalStateVariables = builder.originalStateVariables;
        this.stateVariables = builder.stateVariables;
        this.actions = builder.actions;
        this.childWorkflows = builder.childWorkflows;
        this.retries = builder.retries;
        this.created = builder.created;
        this.modified = builder.modified;
        this.started = builder.started;
        this.executorGroup = builder.executorGroup;
        this.signal = builder.signal;
        this.mapper = builder.mapper;
    }

    public Map<String, String> getChangedStateVariables() {
        if (this.stateVariables == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> changedVariables = new HashMap<String, String>(this.stateVariables.size());
        for (Map.Entry<String, String> current : this.stateVariables.entrySet()) {
            String oldVal = this.originalStateVariables.get(current.getKey());
            if (oldVal != null && oldVal.equals(current.getValue())) continue;
            changedVariables.put(current.getKey(), current.getValue());
        }
        return changedVariables;
    }

    public String getStateVariable(String name) {
        return this.getStateVariable(name, (String)null);
    }

    public <T> T getStateVariable(String name, Class<T> valueType) {
        return this.getStateVariable(name, valueType, null);
    }

    public <T> T getStateVariable(String name, Class<T> valueType, T defaultValue) {
        if (this.mapper == null) {
            throw new IllegalStateException("WorkflowInstance.Builder must be created using WorkflowInstanceFactory.newWorkflowInstanceBuilder(), instance id " + this.id);
        }
        String value = this.stateVariables.get(name);
        if (value != null) {
            return (T)this.mapper.convertToObject(valueType, name, value);
        }
        return defaultValue;
    }

    public String getStateVariable(String name, String defaultValue) {
        return this.stateVariables.getOrDefault(name, defaultValue);
    }

    public static class Builder {
        Long id;
        Integer executorId;
        Long parentWorkflowId;
        Long parentActionId;
        WorkflowInstanceStatus status;
        String type;
        Short priority;
        String businessKey;
        String externalId;
        String state;
        String stateText;
        DateTime nextActivation = DateTime.now();
        final Map<String, String> originalStateVariables = new LinkedHashMap<String, String>();
        final Map<String, String> stateVariables = new LinkedHashMap<String, String>();
        List<WorkflowInstanceAction> actions = new ArrayList<WorkflowInstanceAction>();
        final Map<Long, List<Long>> childWorkflows = new LinkedHashMap<Long, List<Long>>();
        int retries;
        DateTime created;
        DateTime started;
        DateTime modified;
        String executorGroup;
        Optional<Integer> signal = Optional.empty();
        ObjectStringMapper mapper;

        public Builder() {
        }

        public Builder(ObjectStringMapper objectMapper) {
            this.mapper = objectMapper;
        }

        public Builder(WorkflowInstance copy) {
            this.id = copy.id;
            this.executorId = copy.executorId;
            this.parentWorkflowId = copy.parentWorkflowId;
            this.parentActionId = copy.parentActionId;
            this.status = copy.status;
            this.type = copy.type;
            this.priority = copy.priority;
            this.businessKey = copy.businessKey;
            this.externalId = copy.externalId;
            this.state = copy.state;
            this.stateText = copy.stateText;
            this.nextActivation = copy.nextActivation;
            this.originalStateVariables.putAll(copy.originalStateVariables);
            this.stateVariables.putAll(copy.stateVariables);
            this.actions.addAll(copy.actions);
            this.childWorkflows.putAll(copy.childWorkflows);
            this.retries = copy.retries;
            this.created = copy.created;
            this.modified = copy.modified;
            this.started = copy.started;
            this.executorGroup = copy.executorGroup;
            this.signal = copy.signal;
            this.mapper = copy.mapper;
        }

        public Builder setId(long id) {
            this.id = id;
            return this;
        }

        public Builder setExecutorId(Integer executorId) {
            this.executorId = executorId;
            return this;
        }

        public Builder setParentWorkflowId(Long parentWorkflowId) {
            this.parentWorkflowId = parentWorkflowId;
            return this;
        }

        public Builder setParentActionId(Long parentActionId) {
            this.parentActionId = parentActionId;
            return this;
        }

        public Builder setStatus(WorkflowInstanceStatus status) {
            this.status = status;
            return this;
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Builder setPriority(Short priority) {
            this.priority = priority;
            return this;
        }

        public Builder setBusinessKey(String businessKey) {
            this.businessKey = businessKey;
            return this;
        }

        public Builder setExternalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public Builder setState(String state) {
            this.state = state;
            return this;
        }

        public Builder setStateText(String stateText) {
            this.stateText = stateText;
            return this;
        }

        public Builder setNextActivation(DateTime nextActivation) {
            this.nextActivation = nextActivation;
            return this;
        }

        public Builder setOriginalStateVariables(Map<String, String> originalStateVariables) {
            this.originalStateVariables.clear();
            this.originalStateVariables.putAll(originalStateVariables);
            return this;
        }

        public Builder setStateVariables(Map<String, String> stateVariables) {
            this.stateVariables.clear();
            this.stateVariables.putAll(stateVariables);
            return this;
        }

        public Builder putStateVariable(String key, String value) {
            this.assertNotNull(value, "State variable " + key + " value cannot be null");
            this.stateVariables.put(key, value);
            return this;
        }

        @SuppressFBWarnings(value={"WEM_WEAK_EXCEPTION_MESSAGING"}, justification="exception message is ok")
        public Builder putStateVariable(String key, Object value) {
            if (this.mapper == null) {
                throw new IllegalStateException("WorkflowInstance.Builder must be created using WorkflowInstanceFactory.newWorkflowInstanceBuilder()");
            }
            this.assertNotNull(value, "State variable " + key + " value cannot be null");
            this.stateVariables.put(key, this.mapper.convertFromObject(key, value));
            return this;
        }

        @SuppressFBWarnings(value={"WEM_WEAK_EXCEPTION_MESSAGING"}, justification="exception message is ok")
        public Builder putStateVariable(String key, Optional<?> optionalValue) {
            return optionalValue.map(value -> this.putStateVariable(key, value)).orElse(this);
        }

        private void assertNotNull(Object value, String reason) {
            if (value == null) {
                throw new IllegalArgumentException(reason);
            }
        }

        public Builder setActions(List<WorkflowInstanceAction> actions) {
            this.actions = actions;
            return this;
        }

        public Builder setRetries(int retries) {
            this.retries = retries;
            return this;
        }

        public Builder setCreated(DateTime created) {
            this.created = created;
            return this;
        }

        public Builder setModified(DateTime modified) {
            this.modified = modified;
            return this;
        }

        public Builder setStartedIfNotSet(DateTime started) {
            if (this.started == null) {
                this.started = started;
            }
            return this;
        }

        public Builder setExecutorGroup(String executorGroup) {
            this.executorGroup = executorGroup;
            return this;
        }

        public Builder setSignal(Optional<Integer> signal) {
            this.signal = signal;
            return this;
        }

        public WorkflowInstance build() {
            return new WorkflowInstance(this);
        }
    }

    public static enum WorkflowInstanceStatus {
        created,
        inProgress,
        finished,
        manual,
        executing;

    }
}

