/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.workflow.instance;

import io.nflow.engine.model.ModelObject;
import io.nflow.engine.workflow.instance.WorkflowInstance;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.util.Assert;

public class QueryWorkflowInstances
extends ModelObject {
    public final List<Long> ids;
    public final List<String> types;
    public Long parentWorkflowId;
    public Long parentActionId;
    public final List<String> states;
    public final List<WorkflowInstance.WorkflowInstanceStatus> statuses;
    public final String businessKey;
    public final String externalId;
    public final String stateVariableKey;
    public final String stateVariableValue;
    public final boolean includeActions;
    public final boolean includeCurrentStateVariables;
    public final boolean includeActionStateVariables;
    public final boolean includeChildWorkflows;
    public final Long maxResults;
    public final Long maxActions;

    QueryWorkflowInstances(Builder builder) {
        this.ids = new ArrayList<Long>(builder.ids);
        this.types = new ArrayList<String>(builder.types);
        this.parentWorkflowId = builder.parentWorkflowId;
        this.parentActionId = builder.parentActionId;
        this.states = new ArrayList<String>(builder.states);
        this.statuses = new ArrayList<WorkflowInstance.WorkflowInstanceStatus>(builder.statuses);
        this.businessKey = builder.businessKey;
        this.externalId = builder.externalId;
        this.stateVariableKey = builder.stateVariableKey;
        this.stateVariableValue = builder.stateVariableValue;
        this.includeActions = builder.includeActions;
        this.includeCurrentStateVariables = builder.includeCurrentStateVariables;
        this.includeActionStateVariables = builder.includeActionStateVariables;
        this.includeChildWorkflows = builder.includeChildWorkflows;
        this.maxResults = builder.maxResults;
        this.maxActions = builder.maxActions;
    }

    public static class Builder {
        List<Long> ids = new ArrayList<Long>();
        List<String> types = new ArrayList<String>();
        Long parentWorkflowId;
        Long parentActionId;
        List<String> states = new ArrayList<String>();
        List<WorkflowInstance.WorkflowInstanceStatus> statuses = new ArrayList<WorkflowInstance.WorkflowInstanceStatus>();
        String businessKey;
        String externalId;
        String stateVariableKey;
        String stateVariableValue;
        boolean includeActions;
        boolean includeCurrentStateVariables;
        boolean includeActionStateVariables;
        boolean includeChildWorkflows;
        Long maxResults;
        Long maxActions;

        public Builder() {
        }

        public Builder(QueryWorkflowInstances copy) {
            this.ids = copy.ids;
            this.types = copy.types;
            this.parentWorkflowId = copy.parentWorkflowId;
            this.parentActionId = copy.parentActionId;
            this.states = copy.states;
            this.statuses = copy.statuses;
            this.businessKey = copy.businessKey;
            this.externalId = copy.externalId;
            this.stateVariableKey = copy.stateVariableKey;
            this.stateVariableValue = copy.stateVariableValue;
            this.includeActions = copy.includeActions;
            this.includeCurrentStateVariables = copy.includeCurrentStateVariables;
            this.includeActionStateVariables = copy.includeActionStateVariables;
            this.includeChildWorkflows = copy.includeChildWorkflows;
            this.maxResults = copy.maxResults;
            this.maxActions = copy.maxActions;
        }

        public Builder addIds(Long ... newIds) {
            this.ids.addAll(Arrays.asList(newIds));
            return this;
        }

        public Builder addTypes(String ... newTypes) {
            this.types.addAll(Arrays.asList(newTypes));
            return this;
        }

        public Builder setParentWorkflowId(Long parentWorkflowId) {
            this.parentWorkflowId = parentWorkflowId;
            return this;
        }

        public Builder setParentActionId(Long parentActionId) {
            this.parentActionId = parentActionId;
            return this;
        }

        public Builder addStates(String ... newStates) {
            this.states.addAll(Arrays.asList(newStates));
            return this;
        }

        public Builder addStatuses(WorkflowInstance.WorkflowInstanceStatus ... newStatuses) {
            this.statuses.addAll(Arrays.asList(newStatuses));
            return this;
        }

        public Builder setBusinessKey(String businessKey) {
            this.businessKey = businessKey;
            return this;
        }

        public Builder setExternalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public Builder setStateVariable(String stateVariableKey, String stateVariableValue) {
            Assert.notNull((Object)"stateVariableKey cannot be null", stateVariableKey);
            Assert.notNull((Object)"stateVariableValue cannot be null", stateVariableValue);
            this.stateVariableKey = stateVariableKey;
            this.stateVariableValue = stateVariableValue;
            return this;
        }

        public Builder setIncludeActions(boolean includeActions) {
            this.includeActions = includeActions;
            return this;
        }

        public Builder setIncludeCurrentStateVariables(boolean includeCurrentStateVariables) {
            this.includeCurrentStateVariables = includeCurrentStateVariables;
            return this;
        }

        public Builder setIncludeActionStateVariables(boolean includeActionStateVariables) {
            this.includeActionStateVariables = includeActionStateVariables;
            return this;
        }

        public Builder setIncludeChildWorkflows(boolean includeChildWorkflows) {
            this.includeChildWorkflows = includeChildWorkflows;
            return this;
        }

        public Builder setMaxResults(Long maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public Builder setMaxActions(Long maxActions) {
            this.maxActions = maxActions;
            return this;
        }

        public QueryWorkflowInstances build() {
            return new QueryWorkflowInstances(this);
        }
    }
}

