/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.workflow.executor;

import io.nflow.engine.listener.WorkflowExecutorListener;
import io.nflow.engine.workflow.instance.WorkflowInstance;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class WorkflowLogContextListener
implements WorkflowExecutorListener {
    private static final Logger LOG = LoggerFactory.getLogger(WorkflowLogContextListener.class);
    private static final String LOG_CONTEXT_FORMAT = "type:%s, instanceId:%s, extId:%s, businessKey:%s";
    private final String logContext;

    public WorkflowLogContextListener(String logContext) {
        this.logContext = logContext;
    }

    @Override
    public void beforeProcessing(WorkflowExecutorListener.ListenerContext listenerContext) {
        WorkflowInstance instance = listenerContext.instance;
        MDC.put(this.logContext, String.format(LOG_CONTEXT_FORMAT, instance.type, instance.id, instance.externalId, instance.businessKey));
        if (LOG.isDebugEnabled() && !instance.stateVariables.isEmpty()) {
            LOG.debug("State variables:\n{}", (Object)instance.stateVariables.entrySet().stream().map(e -> (String)e.getKey() + ":" + (String)e.getValue()).collect(Collectors.joining("\n")));
        }
    }

    @Override
    public void afterProcessing(WorkflowExecutorListener.ListenerContext listenerContext) {
        MDC.remove(this.logContext);
    }

    @Override
    public void afterFailure(WorkflowExecutorListener.ListenerContext listenerContext, Throwable throwable) {
        MDC.remove(this.logContext);
    }
}

