/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.workflow.definition;

import io.nflow.engine.workflow.instance.WorkflowInstance;
import org.joda.time.DateTime;

public enum WorkflowStateType {
    start(false, WorkflowInstance.WorkflowInstanceStatus.inProgress),
    manual(true, WorkflowInstance.WorkflowInstanceStatus.manual),
    normal(false, WorkflowInstance.WorkflowInstanceStatus.inProgress),
    wait(false, WorkflowInstance.WorkflowInstanceStatus.inProgress),
    end(true, WorkflowInstance.WorkflowInstanceStatus.finished);

    private final boolean isFinal;
    private WorkflowInstance.WorkflowInstanceStatus status;

    private WorkflowStateType(boolean isFinal, WorkflowInstance.WorkflowInstanceStatus status) {
        this.isFinal = isFinal;
        this.status = status;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public WorkflowInstance.WorkflowInstanceStatus getStatus(DateTime nextActivation) {
        if (this.isFinal && nextActivation != null) {
            return WorkflowInstance.WorkflowInstanceStatus.inProgress;
        }
        return this.status;
    }
}

