/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.workflow.definition;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.nflow.engine.workflow.definition.AbstractWorkflowDefinition;
import io.nflow.engine.workflow.definition.WorkflowSettings;
import io.nflow.engine.workflow.definition.WorkflowState;
import java.util.EnumSet;
import java.util.Set;

public abstract class WorkflowDefinition<S extends Enum<S>>
extends AbstractWorkflowDefinition<S> {
    private final Set<S> allStates;

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="findbugs does not understand that S extends both WorkflowState end Enum")
    protected WorkflowDefinition(String type, S initialState, S errorState) {
        this(type, initialState, errorState, new WorkflowSettings.Builder().build());
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="findbugs does not understand that S extends both WorkflowState end Enum")
    protected WorkflowDefinition(String type, S initialState, S errorState, WorkflowSettings settings) {
        super(type, (WorkflowState)initialState, (WorkflowState)errorState, settings);
        this.allStates = EnumSet.allOf(initialState.getClass());
        this.requireEnumValuesHaveMatchingMethod();
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="findbugs does not understand that S extends both WorkflowState end Enum")
    private void requireEnumValuesHaveMatchingMethod() {
        for (Enum state : this.allStates) {
            this.requireStateMethodExists((WorkflowState)((Object)state));
        }
    }

    @Override
    public Set<S> getStates() {
        return this.allStates;
    }
}

