/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.workflow.curated;

import io.nflow.engine.service.MaintenanceConfiguration;
import io.nflow.engine.service.MaintenanceResults;
import io.nflow.engine.service.MaintenanceService;
import io.nflow.engine.workflow.curated.CronWorkflow;
import io.nflow.engine.workflow.definition.NextAction;
import io.nflow.engine.workflow.definition.StateExecution;
import io.nflow.engine.workflow.definition.StateVar;
import io.nflow.engine.workflow.definition.WorkflowSettings;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
public class MaintenanceWorkflow
extends CronWorkflow {
    public static final String MAINTENANCE_WORKFLOW_TYPE = "nFlowMaintenance";
    public static final String VAR_MAINTENANCE_CONFIGURATION = "config";
    @Inject
    private MaintenanceService maintenanceService;

    public MaintenanceWorkflow() {
        super(MAINTENANCE_WORKFLOW_TYPE);
        this.setDescription("Clean up workflow instances periodically.");
    }

    protected MaintenanceWorkflow(String type, WorkflowSettings settings) {
        super(type, settings);
        this.setDescription("Clean up workflow instances periodically.");
    }

    public NextAction doWork(StateExecution execution, @StateVar(value="config", readOnly=true) MaintenanceConfiguration conf) {
        MaintenanceResults results = this.maintenanceService.cleanupWorkflows(conf);
        StringBuilder sb = new StringBuilder(64);
        this.add(sb, "Archived", results.archivedWorkflows);
        this.add(sb, "Deleted", results.deletedWorkflows);
        this.add(sb, "Deleted archived", results.deletedArchivedWorkflows);
        if (sb.length() == 0) {
            sb.append("No actions");
        }
        return NextAction.moveToState(CronWorkflow.State.schedule, sb.toString());
    }

    private void add(StringBuilder sb, String type, int count) {
        if (count > 0) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(type).append(":").append(count);
        }
    }
}

