/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.workflow.curated;

import io.nflow.engine.workflow.definition.NextAction;
import io.nflow.engine.workflow.definition.StateExecution;
import io.nflow.engine.workflow.definition.StateVar;
import io.nflow.engine.workflow.definition.WorkflowDefinition;
import io.nflow.engine.workflow.definition.WorkflowSettings;
import io.nflow.engine.workflow.definition.WorkflowState;
import io.nflow.engine.workflow.definition.WorkflowStateType;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.support.CronSequenceGenerator;

public abstract class CronWorkflow
extends WorkflowDefinition<State> {
    private static final Logger logger = LoggerFactory.getLogger(CronWorkflow.class);
    public static final String VAR_SCHEDULE = "cron";

    protected CronWorkflow(String type, WorkflowSettings settings) {
        super(type, State.schedule, State.handleFailure, settings);
        this.permit(State.schedule, State.doWork);
        this.permit(State.doWork, State.schedule);
        this.permit(State.doWork, State.waitForWorkToFinish);
        this.permit(State.waitForWorkToFinish, State.schedule);
        this.permit(State.handleFailure, State.schedule, State.failed);
    }

    protected CronWorkflow(String type) {
        this(type, new WorkflowSettings.Builder().setHistoryDeletableAfter(Period.days(45)).setDeleteHistoryCondition(WorkflowSettings.Builder.oncePerDay()).build());
    }

    public NextAction schedule(StateExecution execution, @StateVar(value="cron", readOnly=true) String cron) {
        return NextAction.moveToStateAfter(State.doWork, this.getNextActivationTime(execution, cron), "Scheduled");
    }

    protected DateTime getNextActivationTime(StateExecution execution, String cron) {
        return new DateTime(new CronSequenceGenerator(cron).next(DateTime.now().toDate()));
    }

    public NextAction handleFailure(StateExecution execution) {
        if (this.handleFailureImpl(execution)) {
            return NextAction.moveToState(State.schedule, "Failure handled, rescheduling");
        }
        return NextAction.moveToState(State.failed, "Failure handling failed, stopping");
    }

    protected boolean handleFailureImpl(StateExecution execution) {
        logger.error("Cron workflow {} / {} work failed", (Object)this.getType(), (Object)execution.getWorkflowInstanceId());
        return true;
    }

    public NextAction waitForWorkToFinish(StateExecution execution) {
        DateTime waitUntil = this.waitForWorkToFinishImpl(execution);
        if (waitUntil == null) {
            return NextAction.moveToState(State.schedule, "Work finished, rescheduling");
        }
        return NextAction.retryAfter(waitUntil, "Waiting for work to finish");
    }

    protected DateTime waitForWorkToFinishImpl(StateExecution execution) {
        if (execution.hasUnfinishedChildWorkflows()) {
            logger.info("Unfinished child workflow found, waiting before scheduling next work.");
            return DateTime.now().plusHours(1);
        }
        logger.info("No unfinished child workflows found, scheduling next work.");
        return null;
    }

    public static enum State implements WorkflowState
    {
        schedule(WorkflowStateType.start, "Schedule work to be done according to the cron state variable"),
        doWork(WorkflowStateType.normal, "Execute the actual work"),
        waitForWorkToFinish(WorkflowStateType.wait, "Wait for work to finish"),
        handleFailure(WorkflowStateType.normal, "Handle failure and decide if workflow should be re-scheduled or stopped"),
        disabled(WorkflowStateType.manual, "Workflow is disabled"),
        failed(WorkflowStateType.manual, "Processing failed, waiting for manual actions");

        private WorkflowStateType type;
        private String description;

        private State(WorkflowStateType type, String description) {
            this.type = type;
            this.description = description;
        }

        @Override
        public WorkflowStateType getType() {
            return this.type;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

