/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.internal.workflow;

import io.nflow.engine.internal.dao.WorkflowInstanceDao;
import io.nflow.engine.service.WorkflowDefinitionService;
import io.nflow.engine.workflow.definition.AbstractWorkflowDefinition;
import io.nflow.engine.workflow.instance.WorkflowInstance;
import java.util.UUID;
import javax.inject.Inject;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class WorkflowInstancePreProcessor {
    private final WorkflowDefinitionService workflowDefinitionService;
    private final WorkflowInstanceDao workflowInstanceDao;

    @Inject
    public WorkflowInstancePreProcessor(WorkflowDefinitionService workflowDefinitionService, WorkflowInstanceDao workflowInstanceDao) {
        this.workflowDefinitionService = workflowDefinitionService;
        this.workflowInstanceDao = workflowInstanceDao;
    }

    public WorkflowInstance process(WorkflowInstance instance) {
        AbstractWorkflowDefinition<?> def = this.workflowDefinitionService.getWorkflowDefinition(instance.type);
        if (def == null) {
            throw new IllegalArgumentException("No workflow definition found for type [" + instance.type + "]");
        }
        WorkflowInstance.Builder builder = new WorkflowInstance.Builder(instance);
        if (instance.state == null) {
            builder.setState(def.getInitialState().name());
        } else if (!def.isStartState(instance.state)) {
            throw new IllegalArgumentException("Specified state [" + instance.state + "] is not a start state.");
        }
        if (StringUtils.isEmpty(instance.externalId)) {
            builder.setExternalId(UUID.randomUUID().toString());
        }
        if (instance.status == null) {
            builder.setStatus(WorkflowInstance.WorkflowInstanceStatus.created);
        }
        if (instance.priority == null) {
            builder.setPriority(def.getSettings().getDefaultPriority());
        }
        instance.getChangedStateVariables().forEach(this.workflowInstanceDao::checkStateVariableValueLength);
        return builder.build();
    }
}

