/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.internal.workflow;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.nflow.engine.internal.workflow.WorkflowStateMethod;
import io.nflow.engine.workflow.definition.Mutable;
import io.nflow.engine.workflow.definition.NextAction;
import io.nflow.engine.workflow.definition.StateExecution;
import io.nflow.engine.workflow.definition.StateVar;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class WorkflowDefinitionScanner {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowDefinitionScanner.class);
    private static final Set<Class<?>> boxedPrimitiveTypes = Stream.of(Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class).collect(Collectors.collectingAndThen(Collectors.toCollection(LinkedHashSet::new), Collections::unmodifiableSet));
    private static final Set<Type> knownImmutableTypes = Stream.of(Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Character.TYPE, Character.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, String.class, BigDecimal.class, BigInteger.class, Enum.class).collect(Collectors.collectingAndThen(Collectors.toCollection(LinkedHashSet::new), Collections::unmodifiableSet));

    public Map<String, WorkflowStateMethod> getStateMethods(Class<?> definition) {
        LinkedHashMap<String, WorkflowStateMethod> methods = new LinkedHashMap<String, WorkflowStateMethod>();
        ReflectionUtils.doWithMethods(definition, method -> {
            ArrayList<WorkflowStateMethod.StateParameter> params = new ArrayList<WorkflowStateMethod.StateParameter>();
            Type[] genericParameterTypes = method.getGenericParameterTypes();
            Class<?>[] parameterTypes = method.getParameterTypes();
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            block0: for (int i = 1; i < genericParameterTypes.length; ++i) {
                for (Annotation a : parameterAnnotations[i]) {
                    if (!StateVar.class.equals(a.annotationType())) continue;
                    StateVar stateInfo = (StateVar)a;
                    Type type = genericParameterTypes[i];
                    Class clazz = parameterTypes[i];
                    boolean mutable = false;
                    boolean readOnly = this.isReadOnly(type);
                    if (Mutable.class.isAssignableFrom(clazz)) {
                        ParameterizedType pType = (ParameterizedType)type;
                        type = pType.getActualTypeArguments()[0];
                        clazz = (Class)type;
                        readOnly = false;
                        mutable = true;
                    }
                    params.add(new WorkflowStateMethod.StateParameter(stateInfo.value(), type, this.defaultValue(stateInfo, clazz), readOnly || stateInfo.readOnly(), mutable));
                    continue block0;
                }
            }
            if (params.size() != genericParameterTypes.length - 1) {
                throw new IllegalStateException("Not all parameter names could be resolved for " + method + ". Maybe missing @StateVar annotation?");
            }
            if (methods.containsKey(method.getName())) {
                throw new IllegalStateException("Method " + method + " was overloaded. Overloading state methods is not allowed.");
            }
            methods.put(method.getName(), new WorkflowStateMethod(method, params.toArray(new WorkflowStateMethod.StateParameter[params.size()])));
        }, new WorkflowTransitionMethod());
        return methods;
    }

    boolean isReadOnly(Type type) {
        return knownImmutableTypes.contains(type);
    }

    @SuppressFBWarnings(value={"URV_UNRELATED_RETURN_VALUES"}, justification="return values are unrelated")
    Object defaultValue(StateVar stateInfo, Class<?> clazz) {
        if (clazz == Character.TYPE || clazz == Character.class) {
            return Character.valueOf('\u0000');
        }
        if (clazz.isPrimitive() || boxedPrimitiveTypes.contains(clazz)) {
            return ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(ClassUtils.primitiveToWrapper(clazz), "valueOf", String.class), null, "0");
        }
        if (stateInfo != null && stateInfo.instantiateIfNotExists()) {
            try {
                Constructor<?> ctr = clazz.getConstructor(new Class[0]);
                ctr.newInstance(new Object[0]);
                return ctr;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                logger.warn("Could not instantiate {} using empty constructor", (Object)clazz, (Object)e);
            }
        }
        return null;
    }

    static final class WorkflowTransitionMethod
    implements ReflectionUtils.MethodFilter {
        WorkflowTransitionMethod() {
        }

        @Override
        public boolean matches(Method method) {
            int mod = method.getModifiers();
            Class<?>[] parameterTypes = method.getParameterTypes();
            return Modifier.isPublic(mod) && !Modifier.isStatic(mod) && this.hasStateExecutionParameter(parameterTypes) && this.hasValidReturnType(method.getReturnType());
        }

        private boolean hasValidReturnType(Class<?> returnType) {
            return NextAction.class.equals(returnType) || Void.TYPE.equals(returnType);
        }

        private boolean hasStateExecutionParameter(Class<?> ... parameterTypes) {
            return parameterTypes.length >= 1 && StateExecution.class.equals(parameterTypes[0]);
        }
    }
}

