/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.internal.executor;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.nflow.engine.exception.StateProcessExceptionHandling;
import io.nflow.engine.exception.StateSaveExceptionAnalyzer;
import io.nflow.engine.exception.StateSaveExceptionHandling;
import io.nflow.engine.internal.dao.MaintenanceDao;
import io.nflow.engine.internal.dao.WorkflowInstanceDao;
import io.nflow.engine.internal.executor.InvalidNextActionException;
import io.nflow.engine.internal.util.NflowLogger;
import io.nflow.engine.internal.util.PeriodicLogger;
import io.nflow.engine.internal.workflow.ObjectStringMapper;
import io.nflow.engine.internal.workflow.StateExecutionImpl;
import io.nflow.engine.internal.workflow.WorkflowInstancePreProcessor;
import io.nflow.engine.internal.workflow.WorkflowStateMethod;
import io.nflow.engine.listener.ListenerChain;
import io.nflow.engine.listener.WorkflowExecutorListener;
import io.nflow.engine.service.WorkflowDefinitionService;
import io.nflow.engine.service.WorkflowInstanceInclude;
import io.nflow.engine.service.WorkflowInstanceService;
import io.nflow.engine.workflow.definition.AbstractWorkflowDefinition;
import io.nflow.engine.workflow.definition.NextAction;
import io.nflow.engine.workflow.definition.WorkflowSettings;
import io.nflow.engine.workflow.definition.WorkflowState;
import io.nflow.engine.workflow.definition.WorkflowStateType;
import io.nflow.engine.workflow.executor.StateVariableValueTooLongException;
import io.nflow.engine.workflow.instance.WorkflowInstance;
import io.nflow.engine.workflow.instance.WorkflowInstanceAction;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.core.env.Environment;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

class WorkflowStateProcessor
implements Runnable {
    @SuppressFBWarnings(value={"LO_NON_PRIVATE_STATIC_LOGGER"}, justification="Used by inner class")
    static final Logger logger = LoggerFactory.getLogger(WorkflowStateProcessor.class);
    private static final PeriodicLogger laggingLogger = new PeriodicLogger(logger, 30);
    private static final PeriodicLogger threadStuckLogger = new PeriodicLogger(logger, 60);
    private static final String MDC_KEY = "workflowInstanceId";
    private final long instanceId;
    private final WorkflowDefinitionService workflowDefinitions;
    private final WorkflowInstanceService workflowInstances;
    private final WorkflowInstancePreProcessor workflowInstancePreProcessor;
    private final Supplier<Boolean> shutdownRequested;
    final ObjectStringMapper objectMapper;
    private final WorkflowInstanceDao workflowInstanceDao;
    private final MaintenanceDao maintenanceDao;
    private final List<WorkflowExecutorListener> executorListeners;
    final String illegalStateChangeAction;
    private final int unknownWorkflowTypeRetryDelay;
    private final int unknownWorkflowStateRetryDelay;
    private final int stateProcessingRetryDelay;
    private final int stateVariableValueTooLongRetryDelay;
    private final Map<Long, WorkflowStateProcessor> processingInstances;
    private final NflowLogger nflowLogger;
    private final StateSaveExceptionAnalyzer stateSaveExceptionAnalyzer;
    private DateTime startTime;
    private Thread thread;
    private WorkflowExecutorListener.ListenerContext listenerContext;

    WorkflowStateProcessor(long instanceId, Supplier<Boolean> shutdownRequested, ObjectStringMapper objectMapper, WorkflowDefinitionService workflowDefinitions, WorkflowInstanceService workflowInstances, WorkflowInstanceDao workflowInstanceDao, MaintenanceDao maintenanceDao, WorkflowInstancePreProcessor workflowInstancePreProcessor, Environment env, Map<Long, WorkflowStateProcessor> processingInstances, NflowLogger nflowLogger, StateSaveExceptionAnalyzer stateSaveExceptionAnalyzer, WorkflowExecutorListener ... executorListeners) {
        this.instanceId = instanceId;
        this.shutdownRequested = shutdownRequested;
        this.objectMapper = objectMapper;
        this.workflowDefinitions = workflowDefinitions;
        this.workflowInstances = workflowInstances;
        this.workflowInstanceDao = workflowInstanceDao;
        this.maintenanceDao = maintenanceDao;
        this.processingInstances = processingInstances;
        this.nflowLogger = nflowLogger;
        this.stateSaveExceptionAnalyzer = stateSaveExceptionAnalyzer;
        this.executorListeners = Arrays.asList(executorListeners);
        this.workflowInstancePreProcessor = workflowInstancePreProcessor;
        this.illegalStateChangeAction = env.getRequiredProperty("nflow.illegal.state.change.action");
        this.unknownWorkflowTypeRetryDelay = env.getRequiredProperty("nflow.unknown.workflow.type.retry.delay.minutes", Integer.class);
        this.unknownWorkflowStateRetryDelay = env.getRequiredProperty("nflow.unknown.workflow.state.retry.delay.minutes", Integer.class);
        this.stateProcessingRetryDelay = env.getRequiredProperty("nflow.executor.stateProcessingRetryDelay.seconds", Integer.class);
        this.stateVariableValueTooLongRetryDelay = env.getRequiredProperty("nflow.executor.stateVariableValueTooLongRetryDelay.minutes", Integer.class);
    }

    @Override
    public void run() {
        MDC.put(MDC_KEY, String.valueOf(this.instanceId));
        this.startTime = DateTime.now();
        this.thread = Thread.currentThread();
        this.processingInstances.put(this.instanceId, this);
        while (true) {
            try {
                this.runImpl();
            }
            catch (Throwable ex) {
                if (this.shutdownRequested.get().booleanValue()) {
                    logger.error("Failed to process workflow instance and shutdown requested", ex);
                    break;
                }
                logger.error("Failed to process workflow instance {}, retrying after {} seconds", this.instanceId, this.stateProcessingRetryDelay, ex);
                this.sleepIgnoreInterrupted(this.stateProcessingRetryDelay);
                continue;
            }
            break;
        }
        this.processingInstances.remove(this.instanceId);
        MDC.remove(MDC_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runImpl() {
        logger.debug("Starting.");
        WorkflowInstance instance = this.workflowInstances.getWorkflowInstance(this.instanceId, EnumSet.of(WorkflowInstanceInclude.CURRENT_STATE_VARIABLES), null);
        this.logIfLagging(instance);
        AbstractWorkflowDefinition<?> definition = this.workflowDefinitions.getWorkflowDefinition(instance.type);
        if (definition == null) {
            this.rescheduleUnknownWorkflowType(instance);
            return;
        }
        WorkflowSettings settings = definition.getSettings();
        int subsequentStateExecutions = 0;
        while (instance.status == WorkflowInstance.WorkflowInstanceStatus.executing && !this.shutdownRequested.get().booleanValue()) {
            WorkflowState state;
            this.startTime = DateTime.now();
            StateExecutionImpl execution = new StateExecutionImpl(instance, this.objectMapper, this.workflowInstanceDao, this.workflowInstancePreProcessor, this.workflowInstances);
            this.listenerContext = new WorkflowExecutorListener.ListenerContext(definition, instance, execution);
            WorkflowInstanceAction.Builder actionBuilder = new WorkflowInstanceAction.Builder(instance);
            try {
                state = definition.getState(instance.state);
            }
            catch (IllegalArgumentException e) {
                this.rescheduleUnknownWorkflowState(instance);
                return;
            }
            boolean saveInstanceState = true;
            try {
                this.processBeforeListeners();
                this.listenerContext.nextAction = this.processWithListeners(instance, definition, execution, state);
            }
            catch (StateVariableValueTooLongException e) {
                instance = this.rescheduleStateVariableValueTooLong(e, instance);
                saveInstanceState = false;
            }
            catch (Throwable thrown) {
                if (thrown instanceof UndeclaredThrowableException) {
                    thrown = thrown.getCause();
                }
                execution.setFailed(thrown);
                StateProcessExceptionHandling exceptionHandling = settings.analyzeExeption(state, thrown);
                if (exceptionHandling.isRetryable) {
                    this.logRetryableException(exceptionHandling, state.name(), thrown);
                    execution.setRetry(true);
                    execution.setNextState(state);
                    execution.setNextStateReason(ExceptionUtils.getStackTrace(thrown));
                    execution.handleRetryAfter(definition.getSettings().getErrorTransitionActivation(execution.getRetries()), definition);
                    continue;
                }
                logger.error("Handler threw an exception and retrying is not allowed, going to failure state.", thrown);
                execution.handleFailure(definition, "Handler threw an exception and retrying is not allowed");
            }
            finally {
                if (!saveInstanceState) continue;
                if (execution.isFailed()) {
                    this.processAfterFailureListeners(execution.getThrown());
                } else {
                    this.processAfterListeners();
                    this.optionallyCleanupWorkflowInstanceHistory(definition.getSettings(), execution);
                }
                subsequentStateExecutions = this.busyLoopPrevention(state, settings, subsequentStateExecutions, execution);
                instance = this.saveWorkflowInstanceState(execution, instance, definition, actionBuilder);
            }
        }
        logger.debug("Finished.");
    }

    private void logRetryableException(StateProcessExceptionHandling exceptionHandling, String state, Throwable thrown) {
        if (exceptionHandling.logStackTrace) {
            this.nflowLogger.log(logger, exceptionHandling.logLevel, "Handling state '{}' threw a retryable exception, trying again later.", state, thrown);
        } else {
            this.nflowLogger.log(logger, exceptionHandling.logLevel, "Handling state '{}' threw a retryable exception, trying again later. Message: {}", state, thrown.getMessage());
        }
    }

    void logIfLagging(WorkflowInstance instance) {
        Duration executionLag = new Duration(instance.nextActivation, DateTime.now());
        if (executionLag.isLongerThan(Duration.standardMinutes(1L))) {
            laggingLogger.warn("Execution lagging {} seconds.", executionLag.getStandardSeconds());
        }
    }

    private void rescheduleUnknownWorkflowType(WorkflowInstance instance) {
        logger.warn("Workflow type {} not configured to this nFlow instance - rescheduling workflow instance", (Object)instance.type);
        instance = new WorkflowInstance.Builder(instance).setNextActivation(DateTime.now().plusMinutes(this.unknownWorkflowTypeRetryDelay)).setStatus(WorkflowInstance.WorkflowInstanceStatus.inProgress).setStateText("Unsupported workflow type").build();
        this.workflowInstanceDao.updateWorkflowInstance(instance);
        logger.debug("Finished.");
    }

    private void rescheduleUnknownWorkflowState(WorkflowInstance instance) {
        logger.warn("Workflow state {} not configured to workflow type {} - rescheduling workflow instance", (Object)instance.state, (Object)instance.type);
        instance = new WorkflowInstance.Builder(instance).setNextActivation(DateTime.now().plusMinutes(this.unknownWorkflowStateRetryDelay)).setStatus(WorkflowInstance.WorkflowInstanceStatus.inProgress).setStateText("Unsupported workflow state").build();
        this.workflowInstanceDao.updateWorkflowInstance(instance);
        logger.debug("Finished.");
    }

    private WorkflowInstance rescheduleStateVariableValueTooLong(StateVariableValueTooLongException e, WorkflowInstance instance) {
        logger.warn("Failed to process workflow instance {}: {} - rescheduling workflow instance", (Object)instance.id, (Object)e.getMessage());
        instance = new WorkflowInstance.Builder(instance).setNextActivation(DateTime.now().plusMinutes(this.stateVariableValueTooLongRetryDelay)).setStatus(WorkflowInstance.WorkflowInstanceStatus.inProgress).setStateText(e.getMessage()).build();
        this.workflowInstanceDao.updateWorkflowInstance(instance);
        return instance;
    }

    private int busyLoopPrevention(WorkflowState state, WorkflowSettings settings, int subsequentStateExecutions, StateExecutionImpl execution) {
        DateTime nextActivation = execution.getNextActivation();
        int maxSubsequentStateExecutions = settings.getMaxSubsequentStateExecutions(state);
        if (subsequentStateExecutions++ >= maxSubsequentStateExecutions && nextActivation != null) {
            logger.warn("Executed {} times without delay, forcing short transition delay", (Object)maxSubsequentStateExecutions);
            DateTime shortTransitionActivation = settings.getShortTransitionActivation();
            if (nextActivation.isBefore(shortTransitionActivation)) {
                execution.setNextActivation(shortTransitionActivation);
            }
        }
        return subsequentStateExecutions;
    }

    private WorkflowInstance saveWorkflowInstanceState(StateExecutionImpl execution, WorkflowInstance instance, AbstractWorkflowDefinition<?> definition, WorkflowInstanceAction.Builder actionBuilder) {
        if (definition.getMethod(execution.getNextState()) == null && execution.getNextActivation() != null) {
            logger.debug("No handler method defined for {}, clearing next activation", (Object)execution.getNextState());
            execution.setNextActivation(null);
        }
        WorkflowState nextState = definition.getState(execution.getNextState());
        if (instance.parentWorkflowId != null && nextState.getType() == WorkflowStateType.end) {
            try {
                String parentType = this.workflowInstanceDao.getWorkflowInstanceType(instance.parentWorkflowId);
                AbstractWorkflowDefinition<?> parentDefinition = this.workflowDefinitions.getWorkflowDefinition(parentType);
                String[] waitStates = (String[])parentDefinition.getStates().stream().filter(state -> state.getType() == WorkflowStateType.wait).map(WorkflowState::name).toArray(String[]::new);
                if (waitStates.length > 0) {
                    execution.wakeUpParentWorkflow(waitStates);
                }
            }
            catch (EmptyResultDataAccessException parentType) {
                // empty catch block
            }
        }
        WorkflowInstance.Builder instanceBuilder = new WorkflowInstance.Builder(instance).setNextActivation(execution.getNextActivation()).setStatus(this.getStatus(execution, nextState)).setStateText(this.getStateText(instance, execution)).setState(execution.getNextState()).setRetries(execution.isRetry() ? execution.getRetries() + 1 : 0);
        int saveRetryCount = 0;
        if (execution.getNewBusinessKey() != null) {
            instanceBuilder.setBusinessKey(execution.getNewBusinessKey());
        }
        while (true) {
            try {
                return this.persistWorkflowInstanceState(execution, instance.stateVariables, actionBuilder, instanceBuilder);
            }
            catch (Exception ex) {
                if (this.shutdownRequested.get().booleanValue()) {
                    logger.error("Failed to save workflow instance {} new state, not retrying due to shutdown request. The state will be rerun on recovery.", (Object)instance.id, (Object)ex);
                    return instance;
                }
                StateSaveExceptionHandling handling = this.stateSaveExceptionAnalyzer.analyzeSafely(ex, saveRetryCount++);
                if (handling.logStackTrace) {
                    this.nflowLogger.log(logger, handling.logLevel, "Failed to save workflow instance {} new state, retrying after {} seconds.", instance.id, handling.retryDelay, ex);
                } else {
                    this.nflowLogger.log(logger, handling.logLevel, "Failed to save workflow instance {} new state, retrying after {} seconds. Error: {}", instance.id, handling.retryDelay, ex.getMessage());
                }
                this.sleepIgnoreInterrupted(handling.retryDelay.getStandardSeconds());
                continue;
            }
            break;
        }
    }

    private WorkflowInstance persistWorkflowInstanceState(StateExecutionImpl execution, Map<String, String> originalStateVars, WorkflowInstanceAction.Builder actionBuilder, WorkflowInstance.Builder instanceBuilder) {
        if (execution.isStateProcessInvoked()) {
            WorkflowInstanceAction action = actionBuilder.setExecutionEnd(DateTime.now()).setType(this.getActionType(execution)).setStateText(execution.getNextStateReason()).build();
            WorkflowInstance instance = instanceBuilder.setStartedIfNotSet(action.executionStart).build();
            if (execution.isFailed()) {
                this.workflowInstanceDao.updateWorkflowInstanceAfterExecution(instance, action, Collections.emptyList(), Collections.emptyList(), true);
            } else {
                this.workflowInstanceDao.updateWorkflowInstanceAfterExecution(instance, action, execution.getNewChildWorkflows(), execution.getNewWorkflows(), execution.createAction());
                this.processSuccess(execution, instance);
            }
        } else {
            this.workflowInstanceDao.updateWorkflowInstance(instanceBuilder.build());
        }
        return instanceBuilder.setOriginalStateVariables(originalStateVars).build();
    }

    private void processSuccess(StateExecutionImpl execution, WorkflowInstance instance) {
        execution.getWakeUpParentWorkflowStates().ifPresent(expectedStates -> {
            logger.debug("Possibly waking up parent workflow instance {}", (Object)instance.parentWorkflowId);
            try {
                boolean notified = this.workflowInstanceDao.wakeUpWorkflowExternally(instance.parentWorkflowId, (List<String>)expectedStates);
                if (notified) {
                    logger.info("Woke up parent workflow instance {}", (Object)instance.parentWorkflowId);
                } else {
                    logger.info("Did not woke up parent workflow instance {}", (Object)instance.parentWorkflowId);
                }
            }
            catch (DataAccessException e) {
                logger.error("Did not woke up parent workflow instance {}", (Object)instance.parentWorkflowId, (Object)e);
            }
        });
    }

    private String getStateText(WorkflowInstance instance, StateExecutionImpl execution) {
        if (execution.isRetry() || execution.isRetryCountExceeded()) {
            return execution.getNextStateReason();
        }
        if (execution.getNextActivation() == null) {
            return "Stopped in state " + execution.getNextState();
        }
        return "Scheduled by previous state " + instance.state;
    }

    private WorkflowInstance.WorkflowInstanceStatus getStatus(StateExecutionImpl execution, WorkflowState nextState) {
        if (this.isNextActivationImmediately(execution)) {
            return WorkflowInstance.WorkflowInstanceStatus.executing;
        }
        return nextState.getType().getStatus(execution.getNextActivation());
    }

    private WorkflowInstanceAction.WorkflowActionType getActionType(StateExecutionImpl execution) {
        return execution.isFailed() || execution.isRetryCountExceeded() ? WorkflowInstanceAction.WorkflowActionType.stateExecutionFailed : WorkflowInstanceAction.WorkflowActionType.stateExecution;
    }

    private boolean isNextActivationImmediately(StateExecutionImpl execution) {
        return execution.isStateProcessInvoked() && execution.getNextActivation() != null && !execution.getNextActivation().isAfterNow();
    }

    private NextAction processWithListeners(WorkflowInstance instance, AbstractWorkflowDefinition<? extends WorkflowState> definition, StateExecutionImpl execution, WorkflowState state) {
        ProcessingExecutorListener processingListener = new ProcessingExecutorListener(instance, definition, execution, state);
        ArrayList<WorkflowExecutorListener> chain = new ArrayList<WorkflowExecutorListener>(this.executorListeners.size() + 1);
        chain.addAll(this.executorListeners);
        chain.add(processingListener);
        NextAction nextAction = new ExecutorListenerChain(chain).next(this.listenerContext);
        if (execution.isStateProcessInvoked()) {
            return nextAction;
        }
        return new SkippedStateHandler(nextAction, instance, definition, execution, state).processState();
    }

    private void optionallyCleanupWorkflowInstanceHistory(WorkflowSettings settings, StateExecutionImpl execution) {
        try {
            if (settings.historyDeletableAfter != null && (execution.isHistoryCleaningForced() || settings.deleteWorkflowInstanceHistory())) {
                DateTime olderThan = DateTime.now().minus(settings.historyDeletableAfter);
                logger.debug("Cleaning workflow instance {} history older than {}", (Object)this.instanceId, (Object)olderThan);
                this.maintenanceDao.deleteActionAndStateHistory(this.instanceId, olderThan);
            }
        }
        catch (Throwable t) {
            logger.error("Failure in workflow instance {} history cleanup", (Object)this.instanceId, (Object)t);
        }
    }

    private void sleepIgnoreInterrupted(long seconds) {
        try {
            TimeUnit.SECONDS.sleep(seconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void processBeforeListeners() {
        for (WorkflowExecutorListener listener : this.executorListeners) {
            try {
                listener.beforeProcessing(this.listenerContext);
            }
            catch (Throwable t) {
                logger.error("Error in {}.beforeProcessing ({})", listener.getClass().getName(), t.getMessage(), t);
            }
        }
    }

    private void processAfterListeners() {
        for (WorkflowExecutorListener listener : this.executorListeners) {
            try {
                listener.afterProcessing(this.listenerContext);
            }
            catch (Throwable t) {
                logger.error("Error in {}.afterProcessing ({})", listener.getClass().getName(), t.getMessage(), t);
            }
        }
    }

    private void processAfterFailureListeners(Throwable ex) {
        for (WorkflowExecutorListener listener : this.executorListeners) {
            try {
                listener.afterFailure(this.listenerContext, ex);
            }
            catch (Throwable t) {
                logger.error("Error in {}.afterFailure ({})", listener.getClass().getName(), t.getMessage(), t);
            }
        }
    }

    public DateTime getStartTime() {
        return this.startTime;
    }

    public void logPotentiallyStuck(long processingTimeSeconds) {
        threadStuckLogger.warn("Workflow instance {} has been processed for {} seconds, it may be stuck.\n{}", this.instanceId, processingTimeSeconds, this.getStackTraceAsString());
    }

    private StringBuilder getStackTraceAsString() {
        StringBuilder sb = new StringBuilder(2000);
        for (StackTraceElement element : this.thread.getStackTrace()) {
            sb.append(element).append('\n');
        }
        return sb;
    }

    public void handlePotentiallyStuck(Duration processingTime) {
        boolean interrupt = false;
        for (WorkflowExecutorListener listener : this.executorListeners) {
            try {
                if (!listener.handlePotentiallyStuck(this.listenerContext, processingTime)) continue;
                interrupt = true;
            }
            catch (Throwable t) {
                logger.error("Error in " + listener.getClass().getName() + ".handleStuck (" + t.getMessage() + ")", t);
            }
        }
        if (interrupt) {
            this.thread.interrupt();
        }
    }

    private abstract class StateHandler {
        protected final WorkflowInstance instance;
        protected final AbstractWorkflowDefinition<?> definition;
        protected final StateExecutionImpl execution;
        protected final WorkflowState currentState;

        public StateHandler(WorkflowInstance instance, AbstractWorkflowDefinition<?> definition, StateExecutionImpl execution, WorkflowState currentState) {
            this.instance = instance;
            this.definition = definition;
            this.execution = execution;
            this.currentState = currentState;
        }

        protected abstract NextAction getNextAction(WorkflowStateMethod var1, Object ... var2);

        public NextAction processState() {
            NextAction nextAction;
            WorkflowStateMethod method = this.definition.getMethod(this.instance.state);
            if (method == null) {
                this.execution.setNextState(this.currentState);
                return NextAction.stopInState(this.currentState, "Execution finished.");
            }
            Object[] args = WorkflowStateProcessor.this.objectMapper.createArguments(this.execution, method);
            if (this.currentState.getType().isFinal()) {
                this.getNextAction(method, args);
                nextAction = NextAction.stopInState(this.currentState, "Stopped in final state");
            } else {
                Object errorState = this.definition.getErrorState();
                try {
                    nextAction = this.getNextAction(method, args);
                    if (nextAction == null) {
                        logger.error("State '{}' handler method returned null, proceeding to error state '{}'", (Object)this.instance.state, errorState);
                        nextAction = NextAction.moveToState(errorState, "State handler method returned null");
                        this.execution.setFailed();
                    } else {
                        WorkflowState nextState = nextAction.getNextState();
                        if (nextState != null && !this.definition.getStates().contains(nextState)) {
                            logger.error("State '{}' is not a state of '{}' workflow definition, proceeding to error state '{}'", nextState, this.definition.getType(), errorState);
                            nextAction = NextAction.moveToState(errorState, "State '" + this.instance.state + "' handler method returned invalid next state '" + nextState + "'");
                            this.execution.setFailed();
                        } else if (!"ignore".equals(WorkflowStateProcessor.this.illegalStateChangeAction) && !this.definition.isAllowedNextAction(this.instance, nextAction)) {
                            logger.warn("State transition from '{}' to '{}' is not allowed by workflow definition.", (Object)this.instance.state, (Object)nextState);
                            if ("fail".equals(WorkflowStateProcessor.this.illegalStateChangeAction)) {
                                nextAction = NextAction.moveToState(errorState, "Illegal state transition from " + this.instance.state + " to " + nextState + ", proceeding to error state " + errorState);
                                this.execution.setFailed();
                            }
                        }
                    }
                }
                catch (InvalidNextActionException e) {
                    logger.error("State '{}' handler method failed to return valid next action, proceeding to error state '{}'", this.instance.state, errorState, e);
                    nextAction = NextAction.moveToState(errorState, e.getMessage());
                    this.execution.setFailed(e);
                }
            }
            this.execution.setNextActivation(nextAction.getActivation());
            this.execution.setNextStateReason(nextAction.getReason());
            if (!this.execution.isStateProcessInvoked()) {
                this.execution.setNextState(this.currentState);
            } else if (nextAction.isRetry()) {
                this.execution.setNextState(this.currentState);
                this.execution.setRetry(true);
                this.execution.handleRetryAfter(nextAction.getActivation(), this.definition);
            } else {
                this.execution.setNextState(nextAction.getNextState());
            }
            WorkflowStateProcessor.this.objectMapper.storeArguments(this.execution, method, args);
            return nextAction;
        }
    }

    private class SkippedStateHandler
    extends StateHandler {
        private final NextAction nextAction;

        public SkippedStateHandler(NextAction nextAction, WorkflowInstance instance, AbstractWorkflowDefinition<?> definition, StateExecutionImpl execution, WorkflowState currentState) {
            super(instance, definition, execution, currentState);
            this.nextAction = nextAction;
        }

        @Override
        protected NextAction getNextAction(WorkflowStateMethod method, Object ... args) {
            return this.nextAction;
        }
    }

    private class NormalStateHandler
    extends StateHandler {
        public NormalStateHandler(WorkflowInstance instance, AbstractWorkflowDefinition<?> definition, StateExecutionImpl execution, WorkflowState currentState) {
            super(instance, definition, execution, currentState);
        }

        @Override
        protected NextAction getNextAction(WorkflowStateMethod method, Object ... args) {
            this.execution.setStateProcessInvoked(true);
            return (NextAction)ReflectionUtils.invokeMethod(method.method, this.definition, args);
        }
    }

    private class ProcessingExecutorListener
    implements WorkflowExecutorListener {
        private final WorkflowInstance instance;
        private final AbstractWorkflowDefinition<? extends WorkflowState> definition;
        private final StateExecutionImpl execution;
        private final WorkflowState state;

        public ProcessingExecutorListener(WorkflowInstance instance, AbstractWorkflowDefinition<? extends WorkflowState> definition, StateExecutionImpl execution, WorkflowState state) {
            this.instance = instance;
            this.definition = definition;
            this.execution = execution;
            this.state = state;
        }

        @Override
        public NextAction process(WorkflowExecutorListener.ListenerContext context, ListenerChain chain) {
            return new NormalStateHandler(this.instance, this.definition, this.execution, this.state).processState();
        }
    }

    static class ExecutorListenerChain
    implements ListenerChain {
        private final Iterator<WorkflowExecutorListener> chain;

        ExecutorListenerChain(Collection<WorkflowExecutorListener> chain) {
            this.chain = chain.iterator();
        }

        @Override
        public NextAction next(WorkflowExecutorListener.ListenerContext context) {
            Assert.isTrue(this.chain.hasNext(), "Ran out of listeners in listener chain. The last listener must not call " + this.getClass().getSimpleName() + ".next().");
            return this.chain.next().process(context, this);
        }
    }
}

