/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.internal.executor;

import io.nflow.engine.internal.executor.ThresholdBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowInstanceExecutor {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowInstanceExecutor.class);
    private final int awaitTerminationSeconds;
    private final int threadCount;
    final ThreadPoolExecutor executor;
    final ThresholdBlockingQueue<Runnable> queue;

    public WorkflowInstanceExecutor(int maxQueueSize, int threadCount, int notifyThreshold, int awaitTerminationSeconds, int keepAliveSeconds, ThreadFactory threadFactory) {
        this.queue = new ThresholdBlockingQueue(maxQueueSize, notifyThreshold);
        this.executor = new ThreadPoolExecutor(threadCount, threadCount, (long)keepAliveSeconds, TimeUnit.SECONDS, this.queue, threadFactory);
        this.executor.allowCoreThreadTimeOut(keepAliveSeconds > 0);
        this.awaitTerminationSeconds = awaitTerminationSeconds;
        this.threadCount = threadCount;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void waitUntilQueueSizeLowerThanThreshold(DateTime waitUntil) throws InterruptedException {
        this.queue.waitUntilQueueSizeLowerThanThreshold(waitUntil);
    }

    public void wakeUpDispatcherIfNeeded() {
        this.queue.notifyIfNotFull();
    }

    public void execute(Runnable runnable) {
        this.executor.execute(runnable);
    }

    public int getQueueRemainingCapacity() {
        return this.queue.remainingCapacity();
    }

    public void shutdown() {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(this.awaitTerminationSeconds, TimeUnit.SECONDS)) {
                logger.warn("Timed out while waiting for executor to terminate");
            }
        }
        catch (InterruptedException ex) {
            logger.warn("Interrupted while waiting for executor to terminate");
            Thread.currentThread().interrupt();
        }
    }
}

