/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.guice;

import io.nflow.engine.internal.executor.WorkflowLifecycle;
import io.nflow.engine.internal.workflow.MaintenanceWorkflowStarter;
import io.nflow.engine.service.WorkflowDefinitionService;
import io.nflow.engine.workflow.definition.AbstractWorkflowDefinition;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class NflowController {
    private final WorkflowLifecycle lifecycle;
    private final WorkflowDefinitionService workflowDefinitionService;
    private final MaintenanceWorkflowStarter maintenanceWorkflowStarter;
    private final Set<AbstractWorkflowDefinition<?>> workflows;

    @Inject
    public NflowController(WorkflowLifecycle lifecycle, WorkflowDefinitionService workflowDefinitionService, MaintenanceWorkflowStarter maintenanceWorkflowStarter, Set<AbstractWorkflowDefinition<?>> workflowDefinitions) {
        this.lifecycle = lifecycle;
        this.workflowDefinitionService = workflowDefinitionService;
        this.maintenanceWorkflowStarter = maintenanceWorkflowStarter;
        this.workflows = workflowDefinitions;
    }

    public void start() {
        try {
            this.workflows.forEach(this.workflowDefinitionService::addWorkflowDefinition);
            this.maintenanceWorkflowStarter.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to register workflows", e);
        }
        this.lifecycle.start();
    }

    public void stop() {
        this.lifecycle.stop();
    }
}

