/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.guice;

import com.google.inject.AbstractModule;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.ClassPathResource;

public class EnvironmentModule
extends AbstractModule {
    private final Properties userProperties;
    private final String[] classpathPropertiesFiles;

    public EnvironmentModule(Properties userProperties, String ... classpathPropertiesFiles) {
        this.userProperties = userProperties;
        this.classpathPropertiesFiles = classpathPropertiesFiles;
    }

    protected void customizeEnvironment(MutablePropertySources propertySources) {
        propertySources.addFirst(new PropertiesPropertySource("nflowClasspathProperties", this.getClassPathConfigurationProperties()));
        propertySources.addFirst(new PropertiesPropertySource("nflowSystemProperties", System.getProperties()));
        if (this.userProperties != null) {
            propertySources.addFirst(new PropertiesPropertySource("nflowEngineUserProperties", this.userProperties));
        }
    }

    protected Properties getClassPathConfigurationProperties() {
        Properties p = new Properties();
        if (this.classpathPropertiesFiles != null) {
            for (String classpathPropertiesFile : this.classpathPropertiesFiles) {
                ClassPathResource engineProperties = new ClassPathResource(classpathPropertiesFile);
                try (InputStream inputStream = engineProperties.getInputStream();){
                    p.load(inputStream);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return p;
    }

    protected void configure() {
        this.bind(Environment.class).toInstance((Object)new StandardEnvironment(){

            @Override
            protected void customizePropertySources(MutablePropertySources propertySources) {
                EnvironmentModule.this.customizeEnvironment(propertySources);
            }
        });
    }
}

