/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.exception;

import io.nflow.engine.exception.StateSaveExceptionHandling;
import javax.inject.Inject;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class StateSaveExceptionAnalyzer {
    private static final Logger logger = LoggerFactory.getLogger(StateSaveExceptionAnalyzer.class);
    private final StateSaveExceptionHandling handling;

    @Inject
    public StateSaveExceptionAnalyzer(Environment env) {
        Duration retryDelay = Duration.standardSeconds(env.getRequiredProperty("nflow.executor.stateSaveRetryDelay.seconds", Long.class));
        this.handling = new StateSaveExceptionHandling.Builder().setRetryDelay(retryDelay).build();
    }

    public final StateSaveExceptionHandling analyzeSafely(Exception e, int saveRetryCount) {
        try {
            return this.analyze(e, saveRetryCount);
        }
        catch (Exception analyzerException) {
            logger.error("Failed to analyze exception, using default handling.", analyzerException);
            return this.handling;
        }
    }

    protected StateSaveExceptionHandling analyze(Exception e, int saveRetryCount) {
        return this.handling;
    }
}

