/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.config.db;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.nflow.engine.config.NFlow;
import io.nflow.engine.config.db.DatabaseConfiguration;
import io.nflow.engine.internal.storage.db.DatabaseInitializer;
import io.nflow.engine.internal.storage.db.SQLVariants;
import io.nflow.engine.workflow.instance.WorkflowInstance;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.datasource.DataSourceUtils;

@Profile(value={"nflow.db.oracle"})
@Configuration
public class OracleDatabaseConfiguration
extends DatabaseConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(OracleDatabaseConfiguration.class);
    private boolean useBatchUpdate;

    public OracleDatabaseConfiguration() {
        super("oracle");
    }

    @Override
    @Bean
    @SuppressFBWarnings(value={"WEM_WEAK_EXCEPTION_MESSAGING"}, justification="exception message is ok")
    public DatabaseInitializer nflowDatabaseInitializer(@NFlow DataSource nflowDataSource, Environment env) {
        try (Connection c = DataSourceUtils.getConnection(nflowDataSource);){
            DatabaseMetaData meta = c.getMetaData();
            int majorVersion = meta.getDatabaseMajorVersion();
            int minorVersion = meta.getDatabaseMinorVersion();
            logger.info("Oracle {}.{}, product version {}", majorVersion, minorVersion, meta.getDatabaseProductVersion());
            this.useBatchUpdate = majorVersion > 12 || majorVersion == 12 && minorVersion >= 1;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to obtain Oracle version", e);
        }
        return new DatabaseInitializer("oracle", nflowDataSource, env, "/");
    }

    @Override
    @Bean
    @DependsOn(value={"nflowDatabaseInitializer"})
    public SQLVariants sqlVariants(Environment env) {
        return new OracleSqlVariants(this.useBatchUpdate);
    }

    public static class OracleSqlVariants
    implements SQLVariants {
        private final boolean useBatchUpdate;

        public OracleSqlVariants(boolean useBatchUpdate) {
            this.useBatchUpdate = useBatchUpdate;
        }

        @Override
        public String currentTimePlusSeconds(int seconds) {
            return "current_timestamp + interval '" + seconds + "' second";
        }

        @Override
        public boolean hasUpdateableCTE() {
            return false;
        }

        @Override
        public String nextActivationUpdate() {
            return "(case when ? is null then null when external_next_activation is null then ? else least(?, external_next_activation) end)";
        }

        @Override
        public String workflowStatus(WorkflowInstance.WorkflowInstanceStatus status) {
            return "'" + status.name() + "'";
        }

        @Override
        public String workflowStatus() {
            return "?";
        }

        @Override
        public String actionType() {
            return "?";
        }

        @Override
        public String castToText() {
            return "";
        }

        @Override
        public String limit(String query2, long limit) {
            return "select * from (" + query2 + ") where rownum <= " + limit;
        }

        @Override
        public int longTextType() {
            return 2005;
        }

        @Override
        public boolean useBatchUpdate() {
            return this.useBatchUpdate;
        }
    }
}

