/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine;

import io.nflow.engine.config.EngineConfiguration;
import io.nflow.engine.config.NFlow;
import io.nflow.engine.internal.executor.WorkflowLifecycle;
import io.nflow.engine.internal.storage.db.SQLVariants;
import io.nflow.engine.service.HealthCheckService;
import io.nflow.engine.service.MaintenanceService;
import io.nflow.engine.service.StatisticsService;
import io.nflow.engine.service.WorkflowDefinitionService;
import io.nflow.engine.service.WorkflowExecutorService;
import io.nflow.engine.service.WorkflowInstanceService;
import io.nflow.engine.workflow.definition.AbstractWorkflowDefinition;
import io.nflow.engine.workflow.definition.WorkflowState;
import java.util.Collection;
import javax.sql.DataSource;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.support.TransactionTemplate;

public class NflowEngine
implements AutoCloseable {
    private final AnnotationConfigApplicationContext ctx = new AnnotationConfigApplicationContext();
    private final WorkflowLifecycle workflowLifecycle;
    private final MaintenanceService maintenanceService;
    private final HealthCheckService healthCheckService;
    private final StatisticsService statisticsService;
    private final WorkflowDefinitionService workflowDefinitionService;
    private final WorkflowInstanceService workflowInstanceService;
    private final WorkflowExecutorService workflowExecutorService;

    public NflowEngine(DataSource dataSource, SQLVariants sqlVariants, Collection<AbstractWorkflowDefinition<? extends WorkflowState>> workflowDefinitions) {
        this.ctx.registerBean("nflowDatasource", DataSource.class, () -> dataSource, new BeanDefinitionCustomizer[0]);
        this.ctx.registerBean(SQLVariants.class, () -> sqlVariants, new BeanDefinitionCustomizer[0]);
        this.ctx.register(EngineConfiguration.class, NflowEngineSpringConfig.class);
        this.ctx.refresh();
        this.workflowLifecycle = this.ctx.getBean(WorkflowLifecycle.class);
        this.workflowDefinitionService = this.ctx.getBean(WorkflowDefinitionService.class);
        workflowDefinitions.forEach(this.workflowDefinitionService::addWorkflowDefinition);
        this.maintenanceService = this.ctx.getBean(MaintenanceService.class);
        this.healthCheckService = this.ctx.getBean(HealthCheckService.class);
        this.statisticsService = this.ctx.getBean(StatisticsService.class);
        this.workflowInstanceService = this.ctx.getBean(WorkflowInstanceService.class);
        this.workflowExecutorService = this.ctx.getBean(WorkflowExecutorService.class);
    }

    public void start() {
        this.workflowLifecycle.start();
    }

    public void pause() {
        this.workflowLifecycle.pause();
    }

    public void resume() {
        this.workflowLifecycle.resume();
    }

    public boolean isPaused() {
        return this.workflowLifecycle.isPaused();
    }

    public boolean isRunning() {
        return this.workflowLifecycle.isRunning();
    }

    @Override
    public void close() {
        this.ctx.close();
    }

    public MaintenanceService getMaintenanceService() {
        return this.maintenanceService;
    }

    public HealthCheckService getHealthCheckService() {
        return this.healthCheckService;
    }

    public StatisticsService getStatisticsService() {
        return this.statisticsService;
    }

    public WorkflowDefinitionService getWorkflowDefinitionService() {
        return this.workflowDefinitionService;
    }

    public WorkflowInstanceService getWorkflowInstanceService() {
        return this.workflowInstanceService;
    }

    public WorkflowExecutorService getWorkflowExecutorService() {
        return this.workflowExecutorService;
    }

    @EnableTransactionManagement
    protected static class NflowEngineSpringConfig {
        protected NflowEngineSpringConfig() {
        }

        @Bean
        @NFlow
        public JdbcTemplate jdbcTemplate(DataSource dataSource) {
            return new JdbcTemplate(dataSource);
        }

        @Bean
        @NFlow
        public NamedParameterJdbcTemplate namedParameterJdbcTemplate(DataSource dataSource) {
            return new NamedParameterJdbcTemplate(dataSource);
        }

        @Bean
        @NFlow
        public TransactionTemplate transactionTemplate(PlatformTransactionManager transactionManager) {
            return new TransactionTemplate(transactionManager);
        }

        @Bean
        public PlatformTransactionManager transactionManager(DataSource ds) {
            return new DataSourceTransactionManager(ds);
        }
    }
}

