/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.utils;

import java.net.URI;
import java.nio.file.Paths;

public class URIUtils {
    public static URI uriParent(URI uri) {
        return uri.getPath().endsWith("/") ? uri.resolve("..") : uri.resolve(".");
    }

    public static URI convertUriWithoutSchemeToFileScheme(URI uri) {
        if (uri.getScheme() == null) {
            return Paths.get(uri.getPath(), new String[0]).toUri();
        }
        return uri;
    }

    public static URI create(String input) {
        if (URIUtils.isFile(input) || URIUtils.isURL(input)) {
            return URI.create(input);
        }
        return Paths.get(input, new String[0]).toUri();
    }

    private static boolean isFile(String input) {
        return input.toLowerCase().startsWith("file");
    }

    private static boolean isURL(String input) {
        return input.toLowerCase().startsWith("http");
    }
}

