/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.spi;

import com.google.common.base.Optional;
import io.github.swagger2markup.markup.builder.MarkupDocBuilder;
import io.github.swagger2markup.spi.AbstractExtension;
import io.github.swagger2markup.spi.ContentContext;
import io.swagger.models.auth.SecuritySchemeDefinition;
import org.apache.commons.lang3.Validate;

public abstract class SecurityDocumentExtension
extends AbstractExtension {
    public abstract void apply(Context var1);

    protected int levelOffset(Context context) {
        int levelOffset;
        switch (context.position) {
            case DOCUMENT_BEFORE: 
            case DOCUMENT_AFTER: {
                levelOffset = 0;
                break;
            }
            case DOCUMENT_BEGIN: 
            case DOCUMENT_END: 
            case SECURITY_SCHEME_BEFORE: 
            case SECURITY_SCHEME_AFTER: {
                levelOffset = 1;
                break;
            }
            case SECURITY_SCHEME_BEGIN: 
            case SECURITY_SCHEME_END: {
                levelOffset = 2;
                break;
            }
            default: {
                throw new RuntimeException(String.format("Unknown position '%s'", new Object[]{context.position}));
            }
        }
        return levelOffset;
    }

    public static class Context
    extends ContentContext {
        private Position position;
        private String securitySchemeName;
        private SecuritySchemeDefinition securityScheme;

        public Context(Position position, MarkupDocBuilder docBuilder) {
            super(docBuilder);
            Validate.inclusiveBetween(Position.DOCUMENT_BEFORE, Position.DOCUMENT_AFTER, position);
            this.position = position;
        }

        public Context(Position position, MarkupDocBuilder docBuilder, String securitySchemeName, SecuritySchemeDefinition securityScheme) {
            super(docBuilder);
            Validate.inclusiveBetween(Position.SECURITY_SCHEME_BEFORE, Position.SECURITY_SCHEME_AFTER, position);
            Validate.notNull(securitySchemeName);
            Validate.notNull(securityScheme);
            this.position = position;
            this.securitySchemeName = securitySchemeName;
            this.securityScheme = securityScheme;
        }

        public Position getPosition() {
            return this.position;
        }

        public Optional<String> getSecuritySchemeName() {
            return Optional.fromNullable(this.securitySchemeName);
        }

        public Optional<SecuritySchemeDefinition> getSecurityScheme() {
            return Optional.fromNullable(this.securityScheme);
        }
    }

    public static enum Position {
        DOCUMENT_BEFORE,
        DOCUMENT_BEGIN,
        DOCUMENT_END,
        DOCUMENT_AFTER,
        SECURITY_SCHEME_BEFORE,
        SECURITY_SCHEME_BEGIN,
        SECURITY_SCHEME_END,
        SECURITY_SCHEME_AFTER;

    }
}

