/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.model;

import io.swagger.models.HttpMethod;
import io.swagger.models.Operation;
import org.apache.commons.lang3.StringUtils;

public class PathOperation {
    private HttpMethod method;
    private String path;
    private Operation operation;

    public PathOperation(HttpMethod method, String path, Operation operation) {
        this.method = method;
        this.path = path;
        this.operation = operation;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getPath() {
        return this.path;
    }

    public String getTitle() {
        String operationName = this.operation.getSummary();
        if (StringUtils.isBlank(operationName)) {
            operationName = this.getMethod().toString() + " " + this.getPath();
        }
        return operationName;
    }

    public String getId() {
        String id = this.operation.getOperationId();
        if (id == null) {
            id = this.getPath() + " " + this.getMethod().toString().toLowerCase();
        }
        return id;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public String toString() {
        return this.getId();
    }
}

