/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.markup.builder.internal.asciidoc;

import io.github.swagger2markup.markup.builder.MarkupAdmonition;
import io.github.swagger2markup.markup.builder.MarkupBlockStyle;
import io.github.swagger2markup.markup.builder.MarkupDocBuilder;
import io.github.swagger2markup.markup.builder.MarkupLanguage;
import io.github.swagger2markup.markup.builder.MarkupTableColumn;
import io.github.swagger2markup.markup.builder.internal.AbstractMarkupDocBuilder;
import io.github.swagger2markup.markup.builder.internal.Markup;
import io.github.swagger2markup.markup.builder.internal.asciidoc.AsciiDoc;
import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class AsciiDocBuilder
extends AbstractMarkupDocBuilder {
    private static final Pattern TITLE_PATTERN = Pattern.compile(String.format("^(%s{1,%d})\\s+(.*)$", AsciiDoc.TITLE, 6));
    private static final Map<MarkupBlockStyle, String> BLOCK_STYLE = new HashMap<MarkupBlockStyle, String>(){
        {
            this.put(MarkupBlockStyle.EXAMPLE, "====");
            this.put(MarkupBlockStyle.LISTING, "----");
            this.put(MarkupBlockStyle.LITERAL, "....");
            this.put(MarkupBlockStyle.PASSTHROUGH, "++++");
            this.put(MarkupBlockStyle.SIDEBAR, "****");
        }
    };

    public AsciiDocBuilder() {
    }

    public AsciiDocBuilder(String newLine) {
        super(newLine);
    }

    @Override
    protected MarkupLanguage getMarkupLanguage() {
        return MarkupLanguage.ASCIIDOC;
    }

    @Override
    public MarkupDocBuilder copy(boolean copyBuffer) {
        AsciiDocBuilder builder = new AsciiDocBuilder(this.newLine);
        if (copyBuffer) {
            builder.documentBuilder = new StringBuilder(this.documentBuilder);
        }
        return builder.withAnchorPrefix(this.anchorPrefix);
    }

    @Override
    public MarkupDocBuilder documentTitle(String title) {
        this.documentTitle(AsciiDoc.DOCUMENT_TITLE, title);
        return this;
    }

    @Override
    public MarkupDocBuilder sectionTitleLevel(int level, String title) {
        this.sectionTitleLevel(AsciiDoc.TITLE, level, title);
        return this;
    }

    @Override
    public MarkupDocBuilder sectionTitleWithAnchorLevel(int level, String title, String anchor) {
        this.sectionTitleWithAnchorLevel(AsciiDoc.TITLE, level, title, anchor);
        return this;
    }

    @Override
    public MarkupDocBuilder paragraph(String text, boolean hardbreaks) {
        Validate.notBlank(text, "text must not be blank", new Object[0]);
        if (hardbreaks) {
            this.documentBuilder.append("[%hardbreaks]").append(this.newLine);
        }
        text = text.trim();
        this.documentBuilder.append(this.replaceNewLines(text)).append(this.newLine).append(this.newLine);
        return this;
    }

    @Override
    public MarkupDocBuilder pageBreak() {
        this.documentBuilder.append(this.newLine).append("<<<").append(this.newLine);
        return this;
    }

    @Override
    public MarkupDocBuilder block(String text, final MarkupBlockStyle style, String title, MarkupAdmonition admonition) {
        if (admonition != null) {
            this.documentBuilder.append("[").append((Object)admonition).append("]").append(this.newLine);
        }
        if (title != null) {
            this.documentBuilder.append(".").append(title).append(this.newLine);
        }
        this.delimitedBlockText(new Markup(){

            @Override
            public String toString() {
                return (String)BLOCK_STYLE.get((Object)style);
            }
        }, text);
        return this;
    }

    @Override
    public MarkupDocBuilder literalText(String text) {
        this.boldText(AsciiDoc.LITERAL, text);
        return this;
    }

    @Override
    public MarkupDocBuilder boldText(String text) {
        this.boldText(AsciiDoc.BOLD, text);
        return this;
    }

    @Override
    public MarkupDocBuilder italicText(String text) {
        this.italicText(AsciiDoc.ITALIC, text);
        return this;
    }

    @Override
    public MarkupDocBuilder unorderedList(List<String> list) {
        this.unorderedList(AsciiDoc.LIST_ENTRY, list);
        return this;
    }

    @Override
    public MarkupDocBuilder unorderedListItem(String item) {
        this.unorderedListItem(AsciiDoc.LIST_ENTRY, item);
        return this;
    }

    @Override
    public MarkupDocBuilder listingBlock(String text, String language) {
        if (language != null) {
            this.documentBuilder.append(String.format("[source,%s]", language)).append(this.newLine);
        }
        this.block(text, MarkupBlockStyle.LISTING);
        return this;
    }

    private String normalizeAnchor(String anchor) {
        String normalizedAnchor = "_" + this.normalizeAnchor(AsciiDoc.SPACE_ESCAPE, anchor);
        if (normalizedAnchor.endsWith("-")) {
            normalizedAnchor = normalizedAnchor + "_";
        }
        return normalizedAnchor;
    }

    private String normalizeDocument(String document) {
        if (document == null) {
            return null;
        }
        return new File(document).toPath().normalize().toString();
    }

    @Override
    public MarkupDocBuilder anchor(String anchor, String text) {
        this.documentBuilder.append(AsciiDoc.ANCHOR_START).append(this.normalizeAnchor(anchor));
        if (text != null) {
            this.documentBuilder.append(",").append(text);
        }
        this.documentBuilder.append(AsciiDoc.ANCHOR_END);
        return this;
    }

    @Override
    public MarkupDocBuilder crossReferenceRaw(String document, String anchor, String text) {
        this.documentBuilder.append(AsciiDoc.CROSS_REFERENCE_START);
        if (document != null) {
            this.documentBuilder.append(document).append("#");
        }
        this.documentBuilder.append(anchor);
        if (text != null) {
            this.documentBuilder.append(",").append(text);
            if (text.endsWith(">")) {
                this.documentBuilder.append(" ");
            }
        }
        this.documentBuilder.append(AsciiDoc.CROSS_REFERENCE_END);
        return this;
    }

    @Override
    public MarkupDocBuilder crossReference(String document, String anchor, String text) {
        return this.crossReferenceRaw(this.normalizeDocument(document), this.normalizeAnchor(anchor), text);
    }

    private String formatTableCell(String cell) {
        cell = this.replaceNewLines(cell.trim());
        return cell.replace(AsciiDoc.TABLE_COLUMN_DELIMITER.toString(), "\\" + AsciiDoc.TABLE_COLUMN_DELIMITER.toString());
    }

    @Override
    public MarkupDocBuilder tableWithColumnSpecs(List<MarkupTableColumn> columnSpecs, List<List<String>> cells) {
        Validate.notEmpty(cells, "cells must not be null", new Object[0]);
        Boolean hasHeader = false;
        ArrayList<String> options = new ArrayList<String>();
        ArrayList<String> cols = new ArrayList<String>();
        if (columnSpecs != null && !columnSpecs.isEmpty()) {
            for (MarkupTableColumn markupTableColumn : columnSpecs) {
                String languageStyle;
                if (!hasHeader.booleanValue() && StringUtils.isNotBlank(markupTableColumn.header)) {
                    options.add("header");
                    hasHeader = true;
                }
                if ((languageStyle = markupTableColumn.markupSpecifiers.get((Object)MarkupLanguage.ASCIIDOC)) != null && StringUtils.isNoneBlank(languageStyle)) {
                    cols.add(languageStyle);
                    continue;
                }
                cols.add(String.valueOf(markupTableColumn.widthRatio) + (markupTableColumn.headerColumn ? "h" : ""));
            }
        }
        this.newLine();
        this.documentBuilder.append("[options=\"").append(StringUtils.join(options, ",")).append("\", cols=\"").append(StringUtils.join(cols, ",")).append("\"]").append(this.newLine);
        this.documentBuilder.append(AsciiDoc.TABLE).append(this.newLine);
        if (hasHeader.booleanValue()) {
            Collection headerList = columnSpecs.stream().map(header -> this.formatTableCell(StringUtils.defaultString(header.header))).collect(Collectors.toList());
            this.documentBuilder.append(AsciiDoc.TABLE_COLUMN_DELIMITER).append(StringUtils.join(headerList, AsciiDoc.TABLE_COLUMN_DELIMITER.toString())).append(this.newLine);
        }
        for (List list : cells) {
            Collection cellList = list.stream().map(cell -> this.formatTableCell(StringUtils.defaultString(cell))).collect(Collectors.toList());
            this.documentBuilder.append(AsciiDoc.TABLE_COLUMN_DELIMITER).append(StringUtils.join(cellList, AsciiDoc.TABLE_COLUMN_DELIMITER.toString())).append(this.newLine);
        }
        this.documentBuilder.append(AsciiDoc.TABLE).append(this.newLine);
        this.newLine();
        return this;
    }

    @Override
    public MarkupDocBuilder newLine(boolean forceLineBreak) {
        this.newLine(AsciiDoc.LINE_BREAK, forceLineBreak);
        return this;
    }

    @Override
    public MarkupDocBuilder importMarkup(Reader markupText, MarkupLanguage markupLanguage, int levelOffset) {
        this.importMarkupStyle1(TITLE_PATTERN, AsciiDoc.TITLE, markupText, markupLanguage, levelOffset);
        return this;
    }

    @Override
    public String addFileExtension(String fileName) {
        return fileName + MarkupLanguage.ASCIIDOC.getFileNameExtensions().get(0);
    }
}

