/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.internal.utils;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import io.github.swagger2markup.internal.utils.TagUtils;
import io.github.swagger2markup.model.PathOperation;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexUtils {
    private static Logger logger = LoggerFactory.getLogger(TagUtils.class);

    public static String[] toSortedArray(Set<String> groups) {
        Object[] sortedArray = groups.toArray(new String[groups.size()]);
        Arrays.sort(sortedArray);
        return sortedArray;
    }

    public static Multimap<String, PathOperation> groupOperationsByRegex(List<PathOperation> allOperations, Pattern headerPattern) {
        LinkedHashMultimap<String, PathOperation> operationsGroupedByRegex = LinkedHashMultimap.create();
        for (PathOperation operation : allOperations) {
            String path = operation.getPath();
            Matcher m3 = headerPattern.matcher(path);
            if (m3.matches() && m3.group(1) != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Added path operation '{}' to header '{}'", (Object)operation, (Object)m3.group(1));
                }
                operationsGroupedByRegex.put(m3.group(1), operation);
                continue;
            }
            if (!logger.isWarnEnabled()) continue;
            logger.warn("Operation '{}' does not match regex '{}' and will not be included in output", (Object)operation, (Object)headerPattern.toString());
        }
        return operationsGroupedByRegex;
    }
}

