/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.internal.utils;

import io.github.swagger2markup.internal.adapter.ParameterAdapter;
import io.github.swagger2markup.internal.adapter.PropertyAdapter;
import io.github.swagger2markup.internal.resolver.DocumentResolver;
import io.github.swagger2markup.internal.type.ObjectType;
import io.github.swagger2markup.internal.utils.ModelUtils;
import io.github.swagger2markup.markup.builder.MarkupDocBuilder;
import io.github.swagger2markup.model.PathOperation;
import io.swagger.models.ArrayModel;
import io.swagger.models.ComposedModel;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.parameters.RefParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.utils.PropertyModelConverter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ExamplesUtil {
    private static final Integer MAX_RECURSION_TO_DISPLAY = 2;

    public static Map<String, Object> generateResponseExampleMap(boolean generateMissingExamples, PathOperation operation, Map<String, Model> definitions, DocumentResolver definitionDocumentResolver, MarkupDocBuilder markupDocBuilder) {
        LinkedHashMap<String, Object> examples = new LinkedHashMap<String, Object>();
        Map<String, Response> responses = operation.getOperation().getResponses();
        if (responses != null) {
            for (Map.Entry<String, Response> responseEntry : responses.entrySet()) {
                Property schema;
                Model model;
                Response response = responseEntry.getValue();
                Object example = response.getExamples();
                if (example == null && (model = response.getResponseSchema()) != null && (schema = new PropertyModelConverter().modelToProperty(model)) != null) {
                    example = schema.getExample();
                    if (example == null && schema instanceof RefProperty) {
                        String simpleRef = ((RefProperty)schema).getSimpleRef();
                        example = ExamplesUtil.generateExampleForRefModel(generateMissingExamples, simpleRef, definitions, definitionDocumentResolver, markupDocBuilder, new HashMap<String, Integer>());
                    }
                    if (example == null && schema instanceof ArrayProperty && generateMissingExamples) {
                        example = ExamplesUtil.generateExampleForArrayProperty((ArrayProperty)schema, definitions, definitionDocumentResolver, markupDocBuilder, new HashMap<String, Integer>());
                    }
                    if (example == null && generateMissingExamples) {
                        example = PropertyAdapter.generateExample(schema, markupDocBuilder);
                    }
                }
                if (example == null) continue;
                examples.put(responseEntry.getKey(), example);
            }
        }
        return examples;
    }

    public static Map<String, Object> generateRequestExampleMap(boolean generateMissingExamples, PathOperation pathOperation, Map<String, Model> definitions, DocumentResolver definitionDocumentResolver, MarkupDocBuilder markupDocBuilder) {
        Operation operation = pathOperation.getOperation();
        List<Parameter> parameters = operation.getParameters();
        LinkedHashMap<String, Object> examples = new LinkedHashMap<String, Object>();
        if (generateMissingExamples) {
            examples.put("path", pathOperation.getPath());
        }
        for (Parameter parameter : parameters) {
            Object example = null;
            if (parameter instanceof BodyParameter) {
                example = ((BodyParameter)parameter).getExamples();
                if (example == null) {
                    Model schema = ((BodyParameter)parameter).getSchema();
                    if (schema instanceof RefModel) {
                        String simpleRef = ((RefModel)schema).getSimpleRef();
                        example = ExamplesUtil.generateExampleForRefModel(generateMissingExamples, simpleRef, definitions, definitionDocumentResolver, markupDocBuilder, new HashMap<String, Integer>());
                    } else if (generateMissingExamples) {
                        if (schema instanceof ComposedModel) {
                            example = ExamplesUtil.exampleMapForProperties(((ObjectType)ModelUtils.getType(schema, definitions, definitionDocumentResolver)).getProperties(), definitions, definitionDocumentResolver, markupDocBuilder, new HashMap<String, Integer>());
                        } else if (schema instanceof ArrayModel) {
                            example = ExamplesUtil.generateExampleForArrayModel((ArrayModel)schema, definitions, definitionDocumentResolver, markupDocBuilder, new HashMap<String, Integer>());
                        } else {
                            example = schema.getExample();
                            if (example == null) {
                                example = ExamplesUtil.exampleMapForProperties(schema.getProperties(), definitions, definitionDocumentResolver, markupDocBuilder, new HashMap<String, Integer>());
                            }
                        }
                    }
                }
            } else if (parameter instanceof AbstractSerializableParameter) {
                if (generateMissingExamples) {
                    Object abstractSerializableParameterExample = ((AbstractSerializableParameter)parameter).getExample();
                    if (abstractSerializableParameterExample == null) {
                        abstractSerializableParameterExample = parameter.getVendorExtensions().get("x-example");
                    }
                    if (abstractSerializableParameterExample == null) {
                        Property item = ((AbstractSerializableParameter)parameter).getItems();
                        if (item != null && (abstractSerializableParameterExample = item.getExample()) == null) {
                            abstractSerializableParameterExample = PropertyAdapter.generateExample(item, markupDocBuilder);
                        }
                        if (abstractSerializableParameterExample == null) {
                            abstractSerializableParameterExample = ParameterAdapter.generateExample((AbstractSerializableParameter)parameter);
                        }
                    }
                    if (parameter instanceof PathParameter) {
                        String pathExample = (String)examples.get("path");
                        pathExample = pathExample.replace('{' + parameter.getName() + '}', String.valueOf(abstractSerializableParameterExample));
                        example = pathExample;
                    } else if (parameter instanceof QueryParameter) {
                        if (parameter.getRequired()) {
                            String path = (String)examples.get("path");
                            String separator = path.contains("?") ? "&" : "?";
                            String pathExample = path + separator + parameter.getName() + "=" + String.valueOf(abstractSerializableParameterExample);
                            examples.put("path", pathExample);
                        }
                    } else {
                        example = abstractSerializableParameterExample;
                    }
                }
            } else if (parameter instanceof RefParameter) {
                String simpleRef = ((RefParameter)parameter).getSimpleRef();
                example = ExamplesUtil.generateExampleForRefModel(generateMissingExamples, simpleRef, definitions, definitionDocumentResolver, markupDocBuilder, new HashMap<String, Integer>());
            }
            if (example == null) continue;
            examples.put(parameter.getIn(), example);
        }
        return examples;
    }

    private static Object generateExampleForRefModel(boolean generateMissingExamples, String simpleRef, Map<String, Model> definitions, DocumentResolver definitionDocumentResolver, MarkupDocBuilder markupDocBuilder, Map<String, Integer> refStack) {
        Model model = definitions.get(simpleRef);
        Map<String, Object> example = null;
        if (model != null && (example = model.getExample()) == null && generateMissingExamples) {
            if (!refStack.containsKey(simpleRef)) {
                refStack.put(simpleRef, 1);
            } else {
                refStack.put(simpleRef, refStack.get(simpleRef) + 1);
            }
            if (refStack.get(simpleRef) <= MAX_RECURSION_TO_DISPLAY) {
                example = model instanceof ComposedModel ? ExamplesUtil.exampleMapForProperties(((ObjectType)ModelUtils.getType(model, definitions, definitionDocumentResolver)).getProperties(), definitions, definitionDocumentResolver, markupDocBuilder, new HashMap<String, Integer>()) : ExamplesUtil.exampleMapForProperties(model.getProperties(), definitions, definitionDocumentResolver, markupDocBuilder, refStack);
            } else {
                return "...";
            }
            refStack.put(simpleRef, refStack.get(simpleRef) - 1);
        }
        return example;
    }

    private static Map<String, Property> getPropertiesForComposedModel(ComposedModel model, Map<String, Model> definitions) {
        LinkedHashMap<String, Property> combinedProperties;
        if (model.getParent() instanceof RefModel) {
            Map<String, Property> parentProperties = definitions.get(((RefModel)model.getParent()).getSimpleRef()).getProperties();
            if (parentProperties == null) {
                return null;
            }
            combinedProperties = new LinkedHashMap<String, Property>(parentProperties);
        } else {
            combinedProperties = new LinkedHashMap<String, Property>(model.getParent().getProperties());
        }
        Map<String, Property> childProperties = model.getChild() instanceof RefModel ? definitions.get(((RefModel)model.getChild()).getSimpleRef()).getProperties() : model.getChild().getProperties();
        if (childProperties != null) {
            combinedProperties.putAll(childProperties);
        }
        return combinedProperties;
    }

    private static Map<String, Object> exampleMapForProperties(Map<String, Property> properties, Map<String, Model> definitions, DocumentResolver definitionDocumentResolver, MarkupDocBuilder markupDocBuilder, Map<String, Integer> refStack) {
        LinkedHashMap<String, Object> exampleMap = new LinkedHashMap<String, Object>();
        if (properties != null) {
            for (Map.Entry<String, Property> property : properties.entrySet()) {
                Object exampleObject = property.getValue().getExample();
                if (exampleObject == null) {
                    if (property.getValue() instanceof RefProperty) {
                        exampleObject = ExamplesUtil.generateExampleForRefModel(true, ((RefProperty)property.getValue()).getSimpleRef(), definitions, definitionDocumentResolver, markupDocBuilder, refStack);
                    } else if (property.getValue() instanceof ArrayProperty) {
                        exampleObject = ExamplesUtil.generateExampleForArrayProperty((ArrayProperty)property.getValue(), definitions, definitionDocumentResolver, markupDocBuilder, refStack);
                    } else if (property.getValue() instanceof MapProperty) {
                        exampleObject = ExamplesUtil.generateExampleForMapProperty((MapProperty)property.getValue(), markupDocBuilder);
                    }
                    if (exampleObject == null) {
                        Property valueProperty = property.getValue();
                        exampleObject = PropertyAdapter.generateExample(valueProperty, markupDocBuilder);
                    }
                }
                exampleMap.put(property.getKey(), exampleObject);
            }
        }
        return exampleMap;
    }

    private static Object generateExampleForMapProperty(MapProperty property, MarkupDocBuilder markupDocBuilder) {
        if (property.getExample() != null) {
            return property.getExample();
        }
        LinkedHashMap<String, Object> exampleMap = new LinkedHashMap<String, Object>();
        Property valueProperty = property.getAdditionalProperties();
        if (valueProperty.getExample() != null) {
            return valueProperty.getExample();
        }
        exampleMap.put("string", PropertyAdapter.generateExample(valueProperty, markupDocBuilder));
        return exampleMap;
    }

    private static Object generateExampleForArrayModel(ArrayModel model, Map<String, Model> definitions, DocumentResolver definitionDocumentResolver, MarkupDocBuilder markupDocBuilder, Map<String, Integer> refStack) {
        if (model.getExample() != null) {
            return model.getExample();
        }
        if (model.getProperties() != null) {
            return new Object[]{ExamplesUtil.exampleMapForProperties(model.getProperties(), definitions, definitionDocumentResolver, markupDocBuilder, refStack)};
        }
        Property itemProperty = model.getItems();
        return ExamplesUtil.getExample(itemProperty, definitions, definitionDocumentResolver, markupDocBuilder, refStack);
    }

    private static Object[] generateExampleForArrayProperty(ArrayProperty value, Map<String, Model> definitions, DocumentResolver definitionDocumentResolver, MarkupDocBuilder markupDocBuilder, Map<String, Integer> refStack) {
        Property property = value.getItems();
        return ExamplesUtil.getExample(property, definitions, definitionDocumentResolver, markupDocBuilder, refStack);
    }

    private static Object[] getExample(Property property, Map<String, Model> definitions, DocumentResolver definitionDocumentResolver, MarkupDocBuilder markupDocBuilder, Map<String, Integer> refStack) {
        if (property.getExample() != null) {
            return new Object[]{property.getExample()};
        }
        if (property instanceof ArrayProperty) {
            return new Object[]{ExamplesUtil.generateExampleForArrayProperty((ArrayProperty)property, definitions, definitionDocumentResolver, markupDocBuilder, refStack)};
        }
        if (property instanceof RefProperty) {
            return new Object[]{ExamplesUtil.generateExampleForRefModel(true, ((RefProperty)property).getSimpleRef(), definitions, definitionDocumentResolver, markupDocBuilder, refStack)};
        }
        return new Object[]{PropertyAdapter.generateExample(property, markupDocBuilder)};
    }
}

