/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.internal.type;

import io.github.swagger2markup.internal.type.Type;
import io.github.swagger2markup.markup.builder.MarkupDocBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class BasicType
extends Type {
    protected String type;
    protected String format;

    public BasicType(String type, String name) {
        this(type, name, null);
    }

    public BasicType(String type, String name, String format) {
        super(name);
        Validate.notBlank(type, "Type of parameter '%s' must not be blank", name);
        this.type = type;
        this.format = format;
    }

    @Override
    public String displaySchema(MarkupDocBuilder docBuilder) {
        if (StringUtils.isNotBlank(this.format)) {
            return String.format("%s (%s)", this.type, this.format);
        }
        return this.type;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }
}

