/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.internal.type;

import io.github.swagger2markup.internal.type.Type;
import io.github.swagger2markup.markup.builder.MarkupDocBuilder;
import org.apache.commons.lang3.StringUtils;

public class ArrayType
extends Type {
    private String collectionFormat;
    private Type ofType;

    public ArrayType(String name, Type ofType) {
        this(name, ofType, null);
    }

    public ArrayType(String name, Type ofType, String collectionFormat) {
        super(name);
        this.collectionFormat = collectionFormat;
        this.ofType = ofType;
    }

    @Override
    public String displaySchema(MarkupDocBuilder docBuilder) {
        String ofTypeDisplay = this.ofType.displaySchema(docBuilder);
        if (StringUtils.isNotBlank(this.collectionFormat)) {
            return String.format("< %s > array(%s)", ofTypeDisplay, this.collectionFormat);
        }
        return String.format("< %s > array", ofTypeDisplay);
    }

    public String getCollectionFormat() {
        return this.collectionFormat;
    }

    public void setCollectionFormat(String collectionFormat) {
        this.collectionFormat = collectionFormat;
    }

    public Type getOfType() {
        return this.ofType;
    }

    public void setOfType(Type ofType) {
        this.ofType = ofType;
    }
}

