/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.internal.document;

import io.github.swagger2markup.Swagger2MarkupConverter;
import io.github.swagger2markup.internal.component.SecuritySchemeDefinitionComponent;
import io.github.swagger2markup.markup.builder.MarkupDocBuilder;
import io.github.swagger2markup.spi.MarkupComponent;
import io.github.swagger2markup.spi.SecurityDocumentExtension;
import io.swagger.models.auth.SecuritySchemeDefinition;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;

public class SecurityDocument
extends MarkupComponent<Parameters> {
    private static final String SECURITY_ANCHOR = "securityScheme";
    private final SecuritySchemeDefinitionComponent securitySchemeDefinitionComponent;

    public SecurityDocument(Swagger2MarkupConverter.Context context) {
        super(context);
        this.securitySchemeDefinitionComponent = new SecuritySchemeDefinitionComponent(context);
    }

    public static Parameters parameters(Map<String, SecuritySchemeDefinition> securitySchemeDefinitions) {
        return new Parameters(securitySchemeDefinitions);
    }

    @Override
    public MarkupDocBuilder apply(MarkupDocBuilder markupDocBuilder, Parameters params) {
        Map definitions = params.securitySchemeDefinitions;
        if (MapUtils.isNotEmpty(definitions)) {
            this.applySecurityDocumentExtension(new SecurityDocumentExtension.Context(SecurityDocumentExtension.Position.DOCUMENT_BEFORE, markupDocBuilder));
            this.buildSecurityTitle(markupDocBuilder, this.labels.getLabel("security"));
            this.applySecurityDocumentExtension(new SecurityDocumentExtension.Context(SecurityDocumentExtension.Position.DOCUMENT_BEGIN, markupDocBuilder));
            this.buildSecuritySchemeDefinitionsSection(markupDocBuilder, definitions);
            this.applySecurityDocumentExtension(new SecurityDocumentExtension.Context(SecurityDocumentExtension.Position.DOCUMENT_END, markupDocBuilder));
            this.applySecurityDocumentExtension(new SecurityDocumentExtension.Context(SecurityDocumentExtension.Position.DOCUMENT_AFTER, markupDocBuilder));
        }
        return markupDocBuilder;
    }

    private void buildSecurityTitle(MarkupDocBuilder markupDocBuilder, String title) {
        markupDocBuilder.sectionTitleWithAnchorLevel1(title, SECURITY_ANCHOR);
    }

    private void buildSecuritySchemeDefinitionsSection(MarkupDocBuilder markupDocBuilder, Map<String, SecuritySchemeDefinition> securitySchemes) {
        Map<String, SecuritySchemeDefinition> securitySchemeNames = io.github.swagger2markup.internal.utils.MapUtils.toSortedMap(securitySchemes, null);
        securitySchemeNames.forEach((securitySchemeName, securityScheme) -> this.securitySchemeDefinitionComponent.apply(markupDocBuilder, SecuritySchemeDefinitionComponent.parameters(securitySchemeName, securityScheme, 2)));
    }

    private void applySecurityDocumentExtension(SecurityDocumentExtension.Context context) {
        this.extensionRegistry.getSecurityDocumentExtensions().forEach(extension -> extension.apply(context));
    }

    public static class Parameters {
        private final Map<String, SecuritySchemeDefinition> securitySchemeDefinitions;

        public Parameters(Map<String, SecuritySchemeDefinition> securitySchemeDefinitions) {
            this.securitySchemeDefinitions = securitySchemeDefinitions;
        }
    }
}

