/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.internal.document;

import com.google.common.collect.Multimap;
import io.github.swagger2markup.GroupBy;
import io.github.swagger2markup.Swagger2MarkupConfig;
import io.github.swagger2markup.Swagger2MarkupConverter;
import io.github.swagger2markup.internal.component.PathOperationComponent;
import io.github.swagger2markup.internal.resolver.DefinitionDocumentResolverFromOperation;
import io.github.swagger2markup.internal.resolver.OperationDocumentNameResolver;
import io.github.swagger2markup.internal.resolver.OperationDocumentResolverDefault;
import io.github.swagger2markup.internal.resolver.SecurityDocumentResolver;
import io.github.swagger2markup.internal.utils.MarkupDocBuilderUtils;
import io.github.swagger2markup.internal.utils.PathUtils;
import io.github.swagger2markup.internal.utils.RegexUtils;
import io.github.swagger2markup.internal.utils.TagUtils;
import io.github.swagger2markup.markup.builder.MarkupDocBuilder;
import io.github.swagger2markup.model.PathOperation;
import io.github.swagger2markup.spi.MarkupComponent;
import io.github.swagger2markup.spi.PathsDocumentExtension;
import io.github.swagger2markup.utils.IOUtils;
import io.swagger.models.Path;
import io.swagger.models.Tag;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.WordUtils;

public class PathsDocument
extends MarkupComponent<Parameters> {
    private static final String PATHS_ANCHOR = "paths";
    private final PathOperationComponent pathOperationComponent;
    private final OperationDocumentNameResolver operationDocumentNameResolver;
    private final OperationDocumentResolverDefault operationDocumentResolverDefault;

    public PathsDocument(Swagger2MarkupConverter.Context context) {
        super(context);
        this.pathOperationComponent = new PathOperationComponent(context, new DefinitionDocumentResolverFromOperation(context), new SecurityDocumentResolver(context));
        this.operationDocumentNameResolver = new OperationDocumentNameResolver(context);
        this.operationDocumentResolverDefault = new OperationDocumentResolverDefault(context);
        if (this.logger.isDebugEnabled()) {
            if (this.config.isGeneratedExamplesEnabled()) {
                this.logger.debug("Generate examples is enabled.");
            } else {
                this.logger.debug("Generate examples is disabled.");
            }
            if (this.config.isSeparatedOperationsEnabled()) {
                this.logger.debug("Create separated operation files is enabled.");
            } else {
                this.logger.debug("Create separated operation files is disabled.");
            }
        }
    }

    public static Parameters parameters(Map<String, Path> paths) {
        return new Parameters(paths);
    }

    @Override
    public MarkupDocBuilder apply(MarkupDocBuilder markupDocBuilder, Parameters params) {
        Map paths = params.paths;
        if (MapUtils.isNotEmpty(paths)) {
            this.applyPathsDocumentExtension(new PathsDocumentExtension.Context(PathsDocumentExtension.Position.DOCUMENT_BEFORE, markupDocBuilder));
            this.buildPathsTitle(markupDocBuilder);
            this.applyPathsDocumentExtension(new PathsDocumentExtension.Context(PathsDocumentExtension.Position.DOCUMENT_BEGIN, markupDocBuilder));
            this.buildsPathsSection(markupDocBuilder, paths);
            this.applyPathsDocumentExtension(new PathsDocumentExtension.Context(PathsDocumentExtension.Position.DOCUMENT_END, markupDocBuilder));
            this.applyPathsDocumentExtension(new PathsDocumentExtension.Context(PathsDocumentExtension.Position.DOCUMENT_AFTER, markupDocBuilder));
        }
        return markupDocBuilder;
    }

    private void buildsPathsSection(MarkupDocBuilder markupDocBuilder, Map<String, Path> paths) {
        List<PathOperation> pathOperations = PathUtils.toPathOperationsList(paths, this.getBasePath(), this.config.getOperationOrdering());
        if (CollectionUtils.isNotEmpty(pathOperations)) {
            if (this.config.getPathsGroupedBy() == GroupBy.AS_IS) {
                pathOperations.forEach(operation -> this.buildOperation(markupDocBuilder, (PathOperation)operation, this.config));
            } else if (this.config.getPathsGroupedBy() == GroupBy.TAGS) {
                Validate.notEmpty(this.context.getSwagger().getTags(), "Tags must not be empty, when operations are grouped by tags", new Object[0]);
                Multimap<String, PathOperation> operationsGroupedByTag = TagUtils.groupOperationsByTag(pathOperations, this.config.getOperationOrdering());
                Map<String, Tag> tagsMap = TagUtils.toSortedMap(this.context.getSwagger().getTags(), this.config.getTagOrdering());
                tagsMap.forEach((tagName, tag) -> {
                    markupDocBuilder.sectionTitleWithAnchorLevel2(WordUtils.capitalize(tagName), tagName + "_resource");
                    String description = tag.getDescription();
                    if (StringUtils.isNotBlank(description)) {
                        markupDocBuilder.paragraph(description);
                    }
                    operationsGroupedByTag.get((String)tagName).forEach(operation -> this.buildOperation(markupDocBuilder, (PathOperation)operation, this.config));
                });
            } else if (this.config.getPathsGroupedBy() == GroupBy.REGEX) {
                String[] sortedHeaders;
                Validate.notNull(this.config.getHeaderPattern(), "Header regex pattern must not be empty when operations are grouped using regex", new Object[0]);
                Pattern headerPattern = this.config.getHeaderPattern();
                Multimap<String, PathOperation> operationsGroupedByRegex = RegexUtils.groupOperationsByRegex(pathOperations, headerPattern);
                Set<String> keys = operationsGroupedByRegex.keySet();
                for (String header : sortedHeaders = RegexUtils.toSortedArray(keys)) {
                    markupDocBuilder.sectionTitleWithAnchorLevel2(WordUtils.capitalize(header), header + "_resource");
                    operationsGroupedByRegex.get(header).forEach(operation -> this.buildOperation(markupDocBuilder, (PathOperation)operation, this.config));
                }
            }
        }
    }

    private void buildPathsTitle(MarkupDocBuilder markupDocBuilder) {
        if (this.config.getPathsGroupedBy() == GroupBy.AS_IS) {
            this.buildPathsTitle(markupDocBuilder, this.labels.getLabel(PATHS_ANCHOR));
        } else if (this.config.getPathsGroupedBy() == GroupBy.REGEX) {
            this.buildPathsTitle(markupDocBuilder, this.labels.getLabel("operations"));
        } else {
            this.buildPathsTitle(markupDocBuilder, this.labels.getLabel("resources"));
        }
    }

    private String getBasePath() {
        if (this.config.isBasePathPrefixEnabled()) {
            return StringUtils.defaultString(this.context.getSwagger().getBasePath());
        }
        return "";
    }

    private void buildPathsTitle(MarkupDocBuilder markupDocBuilder, String title) {
        markupDocBuilder.sectionTitleWithAnchorLevel1(title, PATHS_ANCHOR);
    }

    private void applyPathsDocumentExtension(PathsDocumentExtension.Context context) {
        this.extensionRegistry.getPathsDocumentExtensions().forEach(extension -> extension.apply(context));
    }

    private void buildOperation(MarkupDocBuilder markupDocBuilder, PathOperation operation, Swagger2MarkupConfig config) {
        if (config.isSeparatedOperationsEnabled()) {
            MarkupDocBuilder pathDocBuilder = MarkupDocBuilderUtils.copyMarkupDocBuilder(markupDocBuilder);
            this.applyPathOperationComponent(pathDocBuilder, operation);
            java.nio.file.Path operationFile = this.context.getOutputPath().resolve(this.operationDocumentNameResolver.apply(operation));
            pathDocBuilder.writeToFileWithoutExtension(operationFile, StandardCharsets.UTF_8, new OpenOption[0]);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Separate operation file produced : '{}'", (Object)operationFile);
            }
            this.buildOperationRef(markupDocBuilder, operation);
        } else {
            this.applyPathOperationComponent(markupDocBuilder, operation);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Operation processed : '{}' (normalized id = '{}')", (Object)operation, (Object)IOUtils.normalizeName(operation.getId()));
        }
    }

    private void applyPathOperationComponent(MarkupDocBuilder markupDocBuilder, PathOperation operation) {
        if (operation != null) {
            this.pathOperationComponent.apply(markupDocBuilder, PathOperationComponent.parameters(operation));
        }
    }

    private void buildOperationRef(MarkupDocBuilder markupDocBuilder, PathOperation operation) {
        this.buildOperationTitle(markupDocBuilder, MarkupDocBuilderUtils.crossReference(markupDocBuilder, this.operationDocumentResolverDefault.apply(operation), operation.getId(), operation.getTitle()), "ref-" + operation.getId());
    }

    private void buildOperationTitle(MarkupDocBuilder markupDocBuilder, String title, String anchor) {
        if (this.config.getPathsGroupedBy() == GroupBy.AS_IS) {
            markupDocBuilder.sectionTitleWithAnchorLevel2(title, anchor);
        } else {
            markupDocBuilder.sectionTitleWithAnchorLevel3(title, anchor);
        }
    }

    public static class Parameters {
        private final Map<String, Path> paths;

        public Parameters(Map<String, Path> paths) {
            this.paths = paths;
        }
    }
}

