/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.internal.document;

import io.github.swagger2markup.Swagger2MarkupConverter;
import io.github.swagger2markup.internal.component.ConsumesComponent;
import io.github.swagger2markup.internal.component.ContactInfoComponent;
import io.github.swagger2markup.internal.component.ExternalDocsComponent;
import io.github.swagger2markup.internal.component.LicenseInfoComponent;
import io.github.swagger2markup.internal.component.ProducesComponent;
import io.github.swagger2markup.internal.component.TagsComponent;
import io.github.swagger2markup.internal.component.UriSchemeComponent;
import io.github.swagger2markup.internal.component.VersionInfoComponent;
import io.github.swagger2markup.internal.utils.MarkupDocBuilderUtils;
import io.github.swagger2markup.markup.builder.MarkupDocBuilder;
import io.github.swagger2markup.spi.MarkupComponent;
import io.github.swagger2markup.spi.OverviewDocumentExtension;
import io.swagger.models.Contact;
import io.swagger.models.ExternalDocs;
import io.swagger.models.Info;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class OverviewDocument
extends MarkupComponent<Parameters> {
    public static final int SECTION_TITLE_LEVEL = 2;
    private static final String OVERVIEW_ANCHOR = "overview";
    private final VersionInfoComponent versionInfoComponent;
    private final ContactInfoComponent contactInfoComponent;
    private final LicenseInfoComponent licenseInfoComponent;
    private final UriSchemeComponent uriSchemeComponent;
    private final TagsComponent tagsComponent;
    private final ProducesComponent producesComponent;
    private final ConsumesComponent consumesComponent;
    private final ExternalDocsComponent externalDocsComponent;

    public OverviewDocument(Swagger2MarkupConverter.Context context) {
        super(context);
        this.versionInfoComponent = new VersionInfoComponent(context);
        this.contactInfoComponent = new ContactInfoComponent(context);
        this.licenseInfoComponent = new LicenseInfoComponent(context);
        this.uriSchemeComponent = new UriSchemeComponent(context);
        this.tagsComponent = new TagsComponent(context);
        this.producesComponent = new ProducesComponent(context);
        this.consumesComponent = new ConsumesComponent(context);
        this.externalDocsComponent = new ExternalDocsComponent(context);
    }

    public static Parameters parameters(Swagger swagger) {
        return new Parameters(swagger);
    }

    @Override
    public MarkupDocBuilder apply(MarkupDocBuilder markupDocBuilder, Parameters params) {
        Swagger swagger = params.swagger;
        Info info = swagger.getInfo();
        this.buildDocumentTitle(markupDocBuilder, info.getTitle());
        this.applyOverviewDocumentExtension(new OverviewDocumentExtension.Context(OverviewDocumentExtension.Position.DOCUMENT_BEFORE, markupDocBuilder));
        this.buildOverviewTitle(markupDocBuilder, this.labels.getLabel(OVERVIEW_ANCHOR));
        this.applyOverviewDocumentExtension(new OverviewDocumentExtension.Context(OverviewDocumentExtension.Position.DOCUMENT_BEGIN, markupDocBuilder));
        this.buildDescriptionParagraph(markupDocBuilder, info.getDescription());
        this.buildVersionInfoSection(markupDocBuilder, info);
        this.buildContactInfoSection(markupDocBuilder, info.getContact());
        this.buildLicenseInfoSection(markupDocBuilder, info);
        this.buildUriSchemeSection(markupDocBuilder, swagger);
        this.buildTagsSection(markupDocBuilder, swagger.getTags());
        this.buildConsumesSection(markupDocBuilder, swagger.getConsumes());
        this.buildProducesSection(markupDocBuilder, swagger.getProduces());
        this.buildExternalDocsSection(markupDocBuilder, swagger.getExternalDocs());
        this.applyOverviewDocumentExtension(new OverviewDocumentExtension.Context(OverviewDocumentExtension.Position.DOCUMENT_END, markupDocBuilder));
        this.applyOverviewDocumentExtension(new OverviewDocumentExtension.Context(OverviewDocumentExtension.Position.DOCUMENT_AFTER, markupDocBuilder));
        return markupDocBuilder;
    }

    private void buildDocumentTitle(MarkupDocBuilder markupDocBuilder, String title) {
        markupDocBuilder.documentTitle(title);
    }

    private void buildOverviewTitle(MarkupDocBuilder markupDocBuilder, String title) {
        markupDocBuilder.sectionTitleWithAnchorLevel1(title, OVERVIEW_ANCHOR);
    }

    void buildDescriptionParagraph(MarkupDocBuilder markupDocBuilder, String description) {
        if (StringUtils.isNotBlank(description)) {
            markupDocBuilder.paragraph(MarkupDocBuilderUtils.markupDescription(this.config.getSwaggerMarkupLanguage(), markupDocBuilder, description));
        }
    }

    private void buildVersionInfoSection(MarkupDocBuilder markupDocBuilder, Info info) {
        if (info != null) {
            this.versionInfoComponent.apply(markupDocBuilder, VersionInfoComponent.parameters(info, 2));
        }
    }

    private void buildContactInfoSection(MarkupDocBuilder markupDocBuilder, Contact contact) {
        if (contact != null) {
            this.contactInfoComponent.apply(markupDocBuilder, ContactInfoComponent.parameters(contact, 2));
        }
    }

    private void buildLicenseInfoSection(MarkupDocBuilder markupDocBuilder, Info info) {
        if (info != null) {
            this.licenseInfoComponent.apply(markupDocBuilder, LicenseInfoComponent.parameters(info, 2));
        }
    }

    private void buildUriSchemeSection(MarkupDocBuilder markupDocBuilder, Swagger swagger) {
        this.uriSchemeComponent.apply(markupDocBuilder, UriSchemeComponent.parameters(swagger, 2));
    }

    private void buildTagsSection(MarkupDocBuilder markupDocBuilder, List<Tag> tags) {
        if (CollectionUtils.isNotEmpty(tags)) {
            this.tagsComponent.apply(markupDocBuilder, TagsComponent.parameters(tags, 2));
        }
    }

    private void buildConsumesSection(MarkupDocBuilder markupDocBuilder, List<String> consumes) {
        if (CollectionUtils.isNotEmpty(consumes)) {
            this.consumesComponent.apply(markupDocBuilder, ConsumesComponent.parameters(consumes, 2));
        }
    }

    private void buildProducesSection(MarkupDocBuilder markupDocBuilder, List<String> produces) {
        if (CollectionUtils.isNotEmpty(produces)) {
            this.producesComponent.apply(markupDocBuilder, ProducesComponent.parameters(produces, 2));
        }
    }

    private void buildExternalDocsSection(MarkupDocBuilder markupDocBuilder, ExternalDocs externalDocs) {
        if (externalDocs != null) {
            this.externalDocsComponent.apply(markupDocBuilder, ExternalDocsComponent.parameters(externalDocs, 2));
        }
    }

    private void applyOverviewDocumentExtension(OverviewDocumentExtension.Context context) {
        this.extensionRegistry.getOverviewDocumentExtensions().forEach(extension -> extension.apply(context));
    }

    public static class Parameters {
        private final Swagger swagger;

        public Parameters(Swagger swagger) {
            this.swagger = Validate.notNull(swagger, "Swagger must not be null", new Object[0]);
        }
    }
}

