/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.internal.component;

import io.github.swagger2markup.Swagger2MarkupConverter;
import io.github.swagger2markup.internal.utils.MarkupDocBuilderUtils;
import io.github.swagger2markup.markup.builder.MarkupDocBuilder;
import io.github.swagger2markup.spi.MarkupComponent;
import io.swagger.models.Swagger;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class UriSchemeComponent
extends MarkupComponent<Parameters> {
    public UriSchemeComponent(Swagger2MarkupConverter.Context context) {
        super(context);
    }

    public static Parameters parameters(Swagger swagger, int titleLevel) {
        return new Parameters(swagger, titleLevel);
    }

    @Override
    public MarkupDocBuilder apply(MarkupDocBuilder markupDocBuilder, Parameters params) {
        Swagger swagger = params.swagger;
        if (StringUtils.isNotBlank(swagger.getHost()) || StringUtils.isNotBlank(swagger.getBasePath()) || CollectionUtils.isNotEmpty(swagger.getSchemes())) {
            markupDocBuilder.sectionTitleLevel(params.titleLevel, this.labels.getLabel("uri_scheme"));
            MarkupDocBuilder paragraphBuilder = MarkupDocBuilderUtils.copyMarkupDocBuilder(markupDocBuilder);
            if (StringUtils.isNotBlank(swagger.getHost())) {
                paragraphBuilder.italicText(this.labels.getLabel("host")).textLine(" : " + swagger.getHost());
            }
            if (StringUtils.isNotBlank(swagger.getBasePath())) {
                paragraphBuilder.italicText(this.labels.getLabel("base_path")).textLine(" : " + swagger.getBasePath());
            }
            if (CollectionUtils.isNotEmpty(swagger.getSchemes())) {
                List schemes = swagger.getSchemes().stream().map(Enum::toString).collect(Collectors.toList());
                paragraphBuilder.italicText(this.labels.getLabel("schemes")).textLine(" : " + StringUtils.join(schemes, ", "));
            }
            markupDocBuilder.paragraph(paragraphBuilder.toString(), true);
        }
        return markupDocBuilder;
    }

    public static class Parameters {
        private final int titleLevel;
        private final Swagger swagger;

        public Parameters(Swagger swagger, int titleLevel) {
            this.swagger = Validate.notNull(swagger);
            this.titleLevel = titleLevel;
        }
    }
}

