/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.internal.component;

import io.github.swagger2markup.Swagger2MarkupConverter;
import io.github.swagger2markup.markup.builder.MarkupDocBuilder;
import io.github.swagger2markup.spi.MarkupComponent;
import io.swagger.models.Tag;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class TagsComponent
extends MarkupComponent<Parameters> {
    public TagsComponent(Swagger2MarkupConverter.Context context) {
        super(context);
    }

    public static Parameters parameters(List<Tag> tags, int titleLevel) {
        return new Parameters(tags, titleLevel);
    }

    @Override
    public MarkupDocBuilder apply(MarkupDocBuilder markupDocBuilder, Parameters params) {
        markupDocBuilder.sectionTitleLevel(params.titleLevel, this.labels.getLabel("tags"));
        List<String> tagsList = params.tags.stream().map(this::mapToString).collect(Collectors.toList());
        if (this.config.getTagOrdering() != null) {
            Collections.sort(tagsList, this.config.getTagOrdering());
        }
        markupDocBuilder.unorderedList(tagsList);
        return markupDocBuilder;
    }

    private String mapToString(Tag tag) {
        String name = tag.getName();
        String description = tag.getDescription();
        if (StringUtils.isNotBlank(description)) {
            return name + " : " + description;
        }
        return name;
    }

    public static class Parameters {
        private final List<Tag> tags;
        private final int titleLevel;

        public Parameters(List<Tag> tags, int titleLevel) {
            this.tags = Validate.notNull(tags, "Tags must not be null", new Object[0]);
            this.titleLevel = titleLevel;
        }
    }
}

