/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.internal.component;

import ch.netzwerg.paleo.DataFrame;
import ch.netzwerg.paleo.StringColumn;
import io.github.swagger2markup.Swagger2MarkupConverter;
import io.github.swagger2markup.markup.builder.MarkupDocBuilder;
import io.github.swagger2markup.markup.builder.MarkupLanguage;
import io.github.swagger2markup.markup.builder.MarkupTableColumn;
import io.github.swagger2markup.spi.MarkupComponent;
import io.vavr.collection.Array;
import io.vavr.collection.IndexedSeq;
import io.vavr.collection.List;
import io.vavr.collection.Seq;
import org.apache.commons.lang3.StringUtils;

public class TableComponent
extends MarkupComponent<Parameters> {
    public static final String WIDTH_RATIO = "widthRatio";
    public static final String HEADER_COLUMN = "headerColumn";

    public TableComponent(Swagger2MarkupConverter.Context context) {
        super(context);
    }

    public static Parameters parameters(StringColumn ... columns) {
        return new Parameters(columns);
    }

    public static boolean isNotBlank(StringColumn column) {
        return !column.getValues().filter(StringUtils::isNotBlank).isEmpty();
    }

    @Override
    public MarkupDocBuilder apply(MarkupDocBuilder markupDocBuilder, Parameters params) {
        DataFrame dataFrame = params.dataFrame;
        java.util.List<MarkupTableColumn> columnSpecs = dataFrame.getColumns().map(column -> {
            Integer widthRatio = Integer.valueOf(column.getMetaData().get(WIDTH_RATIO).getOrElse("0"));
            return new MarkupTableColumn(column.getId().getName()).withWidthRatio(widthRatio).withHeaderColumn(Boolean.parseBoolean(column.getMetaData().get(HEADER_COLUMN).getOrElse("false"))).withMarkupSpecifiers(MarkupLanguage.ASCIIDOC, ".^" + widthRatio + "a");
        }).toJavaList();
        Seq columnValues = dataFrame.getColumns().map(column -> ((StringColumn)column).getValues());
        java.util.List<java.util.List<String>> cells = Array.range(0, dataFrame.getRowCount()).map(arg_0 -> TableComponent.lambda$apply$3((IndexedSeq)columnValues, arg_0)).toJavaList();
        return markupDocBuilder.tableWithColumnSpecs(columnSpecs, cells);
    }

    private static /* synthetic */ java.util.List lambda$apply$3(IndexedSeq columnValues, Integer rowNumber) {
        return columnValues.map(values -> (String)values.get(rowNumber)).toJavaList();
    }

    public static class Parameters {
        private final DataFrame dataFrame;

        public Parameters(StringColumn ... columns) {
            this.dataFrame = DataFrame.ofAll(List.of(columns).filter(TableComponent::isNotBlank));
        }
    }
}

