/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.internal.component;

import ch.netzwerg.paleo.ColumnIds;
import ch.netzwerg.paleo.StringColumn;
import com.google.common.base.Joiner;
import io.github.swagger2markup.Swagger2MarkupConverter;
import io.github.swagger2markup.internal.component.TableComponent;
import io.github.swagger2markup.internal.resolver.DocumentResolver;
import io.github.swagger2markup.internal.utils.MarkupDocBuilderUtils;
import io.github.swagger2markup.markup.builder.MarkupDocBuilder;
import io.github.swagger2markup.model.PathOperation;
import io.github.swagger2markup.spi.MarkupComponent;
import io.github.swagger2markup.spi.PathsDocumentExtension;
import io.swagger.models.auth.SecuritySchemeDefinition;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class SecuritySchemeComponent
extends MarkupComponent<Parameters> {
    private final Map<String, SecuritySchemeDefinition> securityDefinitions;
    private final DocumentResolver securityDocumentResolver;
    private final TableComponent tableComponent;

    public SecuritySchemeComponent(Swagger2MarkupConverter.Context context, DocumentResolver securityDocumentResolver) {
        super(context);
        this.securityDefinitions = context.getSwagger().getSecurityDefinitions();
        this.securityDocumentResolver = Validate.notNull(securityDocumentResolver, "SecurityDocumentResolver must not be null", new Object[0]);
        this.tableComponent = new TableComponent(context);
    }

    public static Parameters parameters(PathOperation operation, int titleLevel) {
        return new Parameters(operation, titleLevel);
    }

    @Override
    public MarkupDocBuilder apply(MarkupDocBuilder markupDocBuilder, Parameters params) {
        PathOperation operation = params.operation;
        MarkupDocBuilder securityBuilder = MarkupDocBuilderUtils.copyMarkupDocBuilder(markupDocBuilder);
        List<Map<String, List<String>>> securitySchemes = operation.getOperation().getSecurity();
        this.applyPathsDocumentExtension(new PathsDocumentExtension.Context(PathsDocumentExtension.Position.OPERATION_SECURITY_BEGIN, securityBuilder, operation));
        if (CollectionUtils.isNotEmpty(securitySchemes)) {
            StringColumn.Builder typeColumnBuilder = StringColumn.builder(ColumnIds.StringColumnId.of(this.labels.getLabel("type_column"))).putMetaData("widthRatio", "3");
            StringColumn.Builder nameColumnBuilder = StringColumn.builder(ColumnIds.StringColumnId.of(this.labels.getLabel("name_column"))).putMetaData("widthRatio", "4");
            StringColumn.Builder scopeColumnBuilder = StringColumn.builder(ColumnIds.StringColumnId.of(this.labels.getLabel("scopes_column"))).putMetaData("widthRatio", "13").putMetaData("headerColumn", "true");
            for (Map<String, List<String>> securityScheme : securitySchemes) {
                for (Map.Entry<String, List<String>> securityEntry : securityScheme.entrySet()) {
                    String securityKey = securityEntry.getKey();
                    String type = this.labels.getLabel("unknown");
                    if (this.securityDefinitions != null && this.securityDefinitions.containsKey(securityKey)) {
                        type = this.securityDefinitions.get(securityKey).getType();
                    }
                    typeColumnBuilder.add(MarkupDocBuilderUtils.boldText(markupDocBuilder, type));
                    nameColumnBuilder.add(MarkupDocBuilderUtils.boldText(markupDocBuilder, MarkupDocBuilderUtils.crossReference(markupDocBuilder, (String)this.securityDocumentResolver.apply(securityKey), securityKey, securityKey)));
                    scopeColumnBuilder.add(Joiner.on(",").join((Iterable)securityEntry.getValue()));
                }
            }
            securityBuilder = this.tableComponent.apply(securityBuilder, TableComponent.parameters(typeColumnBuilder.build(), nameColumnBuilder.build(), scopeColumnBuilder.build()));
        }
        this.applyPathsDocumentExtension(new PathsDocumentExtension.Context(PathsDocumentExtension.Position.OPERATION_SECURITY_END, securityBuilder, operation));
        String securityContent = securityBuilder.toString();
        this.applyPathsDocumentExtension(new PathsDocumentExtension.Context(PathsDocumentExtension.Position.OPERATION_SECURITY_BEFORE, markupDocBuilder, operation));
        if (StringUtils.isNotBlank(securityContent)) {
            markupDocBuilder.sectionTitleLevel(params.titleLevel, this.labels.getLabel("security"));
            markupDocBuilder.text(securityContent);
        }
        this.applyPathsDocumentExtension(new PathsDocumentExtension.Context(PathsDocumentExtension.Position.OPERATION_SECURITY_AFTER, markupDocBuilder, operation));
        return markupDocBuilder;
    }

    private void applyPathsDocumentExtension(PathsDocumentExtension.Context context) {
        this.extensionRegistry.getPathsDocumentExtensions().forEach(extension -> extension.apply(context));
    }

    public static class Parameters {
        private final PathOperation operation;
        private final int titleLevel;

        public Parameters(PathOperation operation, int titleLevel) {
            this.operation = Validate.notNull(operation, "PathOperation must not be null", new Object[0]);
            this.titleLevel = titleLevel;
        }
    }
}

