/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.internal.component;

import ch.netzwerg.paleo.ColumnIds;
import ch.netzwerg.paleo.StringColumn;
import io.github.swagger2markup.Swagger2MarkupConverter;
import io.github.swagger2markup.internal.adapter.ParameterAdapter;
import io.github.swagger2markup.internal.component.TableComponent;
import io.github.swagger2markup.internal.resolver.DocumentResolver;
import io.github.swagger2markup.internal.type.ObjectType;
import io.github.swagger2markup.internal.utils.MarkupDocBuilderUtils;
import io.github.swagger2markup.markup.builder.MarkupDocBuilder;
import io.github.swagger2markup.model.PathOperation;
import io.github.swagger2markup.spi.MarkupComponent;
import io.github.swagger2markup.spi.PathsDocumentExtension;
import io.swagger.models.parameters.Parameter;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class ParameterTableComponent
extends MarkupComponent<Parameters> {
    private final DocumentResolver definitionDocumentResolver;
    private final TableComponent tableComponent;

    ParameterTableComponent(Swagger2MarkupConverter.Context context, DocumentResolver definitionDocumentResolver) {
        super(context);
        this.definitionDocumentResolver = Validate.notNull(definitionDocumentResolver, "DocumentResolver must not be null", new Object[0]);
        this.tableComponent = new TableComponent(context);
    }

    public static Parameters parameters(PathOperation operation, List<ObjectType> inlineDefinitions, int titleLevel) {
        return new Parameters(operation, inlineDefinitions, titleLevel);
    }

    @Override
    public MarkupDocBuilder apply(MarkupDocBuilder markupDocBuilder, Parameters params) {
        PathOperation operation = params.operation;
        List inlineDefinitions = params.inlineDefinitions;
        List<Parameter> parameters = operation.getOperation().getParameters();
        if (this.config.getParameterOrdering() != null) {
            parameters.sort(this.config.getParameterOrdering());
        }
        List filteredParameters = parameters.stream().filter(this::filterParameter).collect(Collectors.toList());
        MarkupDocBuilder parametersBuilder = MarkupDocBuilderUtils.copyMarkupDocBuilder(markupDocBuilder);
        this.applyPathsDocumentExtension(new PathsDocumentExtension.Context(PathsDocumentExtension.Position.OPERATION_PARAMETERS_BEGIN, parametersBuilder, operation));
        if (CollectionUtils.isNotEmpty(filteredParameters)) {
            StringColumn.Builder typeColumnBuilder = StringColumn.builder(ColumnIds.StringColumnId.of(this.labels.getLabel("type_column"))).putMetaData("widthRatio", "2");
            StringColumn.Builder nameColumnBuilder = StringColumn.builder(ColumnIds.StringColumnId.of(this.labels.getLabel("name_column"))).putMetaData("widthRatio", "3");
            StringColumn.Builder descriptionColumnBuilder = StringColumn.builder(ColumnIds.StringColumnId.of(this.labels.getLabel("description_column"))).putMetaData("widthRatio", "9").putMetaData("headerColumn", "true");
            StringColumn.Builder schemaColumnBuilder = StringColumn.builder(ColumnIds.StringColumnId.of(this.labels.getLabel("schema_column"))).putMetaData("widthRatio", "4").putMetaData("headerColumn", "true");
            StringColumn.Builder defaultColumnBuilder = StringColumn.builder(ColumnIds.StringColumnId.of(this.labels.getLabel("default_column"))).putMetaData("widthRatio", "2").putMetaData("headerColumn", "true");
            for (Parameter parameter : filteredParameters) {
                ParameterAdapter parameterAdapter = new ParameterAdapter(this.context, operation, parameter, this.definitionDocumentResolver);
                inlineDefinitions.addAll(parameterAdapter.getInlineDefinitions());
                typeColumnBuilder.add(parameterAdapter.displayType(markupDocBuilder));
                nameColumnBuilder.add(this.getParameterNameColumnContent(markupDocBuilder, parameterAdapter));
                descriptionColumnBuilder.add(parameterAdapter.displayDescription(markupDocBuilder));
                schemaColumnBuilder.add(parameterAdapter.displaySchema(markupDocBuilder));
                defaultColumnBuilder.add(parameterAdapter.displayDefaultValue(markupDocBuilder));
            }
            parametersBuilder = this.tableComponent.apply(parametersBuilder, TableComponent.parameters(typeColumnBuilder.build(), nameColumnBuilder.build(), descriptionColumnBuilder.build(), schemaColumnBuilder.build(), defaultColumnBuilder.build()));
        }
        this.applyPathsDocumentExtension(new PathsDocumentExtension.Context(PathsDocumentExtension.Position.OPERATION_PARAMETERS_END, parametersBuilder, operation));
        String parametersContent = parametersBuilder.toString();
        this.applyPathsDocumentExtension(new PathsDocumentExtension.Context(PathsDocumentExtension.Position.OPERATION_PARAMETERS_BEFORE, markupDocBuilder, operation));
        if (StringUtils.isNotBlank(parametersContent)) {
            markupDocBuilder.sectionTitleLevel(params.titleLevel, this.labels.getLabel("parameters"));
            markupDocBuilder.text(parametersContent);
        }
        this.applyPathsDocumentExtension(new PathsDocumentExtension.Context(PathsDocumentExtension.Position.OPERATION_PARAMETERS_AFTER, markupDocBuilder, operation));
        return markupDocBuilder;
    }

    private String getParameterNameColumnContent(MarkupDocBuilder markupDocBuilder, ParameterAdapter parameter) {
        MarkupDocBuilder parameterNameContent = MarkupDocBuilderUtils.copyMarkupDocBuilder(markupDocBuilder);
        parameterNameContent.boldTextLine(parameter.getName(), true);
        if (parameter.getRequired()) {
            parameterNameContent.italicText(this.labels.getLabel("flags.required").toLowerCase());
        } else {
            parameterNameContent.italicText(this.labels.getLabel("flags.optional").toLowerCase());
        }
        return parameterNameContent.toString();
    }

    private boolean filterParameter(Parameter parameter) {
        return !this.config.isFlatBodyEnabled() || !StringUtils.equals(parameter.getIn(), "body");
    }

    private void applyPathsDocumentExtension(PathsDocumentExtension.Context context) {
        this.extensionRegistry.getPathsDocumentExtensions().forEach(extension -> extension.apply(context));
    }

    public static class Parameters {
        private final PathOperation operation;
        private final int titleLevel;
        private final List<ObjectType> inlineDefinitions;

        public Parameters(PathOperation operation, List<ObjectType> inlineDefinitions, int titleLevel) {
            this.operation = Validate.notNull(operation, "PathOperation must not be null", new Object[0]);
            this.inlineDefinitions = Validate.notNull(inlineDefinitions, "InlineDefinitions must not be null", new Object[0]);
            this.titleLevel = titleLevel;
        }
    }
}

