/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.internal.component;

import io.github.swagger2markup.Swagger2MarkupConverter;
import io.github.swagger2markup.internal.utils.MarkupDocBuilderUtils;
import io.github.swagger2markup.markup.builder.MarkupDocBuilder;
import io.github.swagger2markup.spi.MarkupComponent;
import io.swagger.models.ExternalDocs;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class ExternalDocsComponent
extends MarkupComponent<Parameters> {
    public ExternalDocsComponent(Swagger2MarkupConverter.Context context) {
        super(context);
    }

    public static Parameters parameters(ExternalDocs externalDocs, int titleLevel) {
        return new Parameters(externalDocs, titleLevel);
    }

    @Override
    public MarkupDocBuilder apply(MarkupDocBuilder markupDocBuilder, Parameters params) {
        ExternalDocs externalDocs = params.externalDocs;
        String description = externalDocs.getDescription();
        String url = externalDocs.getUrl();
        if (description != null && (StringUtils.isNotBlank(description) || url != null && StringUtils.isNotBlank(url))) {
            markupDocBuilder.sectionTitleLevel(params.titleLevel, this.labels.getLabel("external_docs"));
            MarkupDocBuilder paragraph = MarkupDocBuilderUtils.copyMarkupDocBuilder(markupDocBuilder);
            if (StringUtils.isNotBlank(description)) {
                paragraph.italicText(this.labels.getLabel("external_docs_desc")).textLine(" : " + description);
            }
            if (StringUtils.isNotBlank(url)) {
                paragraph.italicText(this.labels.getLabel("external_docs_url")).textLine(" : " + url);
            }
            markupDocBuilder.paragraph(paragraph.toString(), true);
        }
        return markupDocBuilder;
    }

    public static class Parameters {
        private final int titleLevel;
        private final ExternalDocs externalDocs;

        public Parameters(ExternalDocs externalDocs, int titleLevel) {
            this.externalDocs = Validate.notNull(externalDocs, "ExternalDocs must not be null", new Object[0]);
            this.titleLevel = titleLevel;
        }
    }
}

