/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.internal.component;

import io.github.swagger2markup.Swagger2MarkupConverter;
import io.github.swagger2markup.internal.utils.MarkupDocBuilderUtils;
import io.github.swagger2markup.markup.builder.MarkupDocBuilder;
import io.github.swagger2markup.spi.MarkupComponent;
import io.swagger.models.Contact;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class ContactInfoComponent
extends MarkupComponent<Parameters> {
    public ContactInfoComponent(Swagger2MarkupConverter.Context context) {
        super(context);
    }

    public static Parameters parameters(Contact contact, int titleLevel) {
        return new Parameters(contact, titleLevel);
    }

    @Override
    public MarkupDocBuilder apply(MarkupDocBuilder markupDocBuilder, Parameters params) {
        Contact contact = params.contact;
        if (StringUtils.isNotBlank(contact.getName()) || StringUtils.isNotBlank(contact.getEmail())) {
            markupDocBuilder.sectionTitleLevel(params.titleLevel, this.labels.getLabel("contact_information"));
            MarkupDocBuilder paragraphBuilder = MarkupDocBuilderUtils.copyMarkupDocBuilder(markupDocBuilder);
            if (StringUtils.isNotBlank(contact.getName())) {
                paragraphBuilder.italicText(this.labels.getLabel("contact_name")).textLine(" : " + contact.getName());
            }
            if (StringUtils.isNotBlank(contact.getEmail())) {
                paragraphBuilder.italicText(this.labels.getLabel("contact_email")).textLine(" : " + contact.getEmail());
            }
            markupDocBuilder.paragraph(paragraphBuilder.toString(), true);
        }
        return markupDocBuilder;
    }

    public static class Parameters {
        private final Contact contact;
        private final int titleLevel;

        public Parameters(Contact contact, int titleLevel) {
            this.contact = Validate.notNull(contact, "Contact must not be null", new Object[0]);
            this.titleLevel = titleLevel;
        }
    }
}

