/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.internal.adapter;

import io.github.swagger2markup.internal.resolver.DocumentResolver;
import io.github.swagger2markup.internal.type.ArrayType;
import io.github.swagger2markup.internal.type.BasicType;
import io.github.swagger2markup.internal.type.EnumType;
import io.github.swagger2markup.internal.type.MapType;
import io.github.swagger2markup.internal.type.ObjectType;
import io.github.swagger2markup.internal.type.RefType;
import io.github.swagger2markup.internal.type.Type;
import io.github.swagger2markup.markup.builder.MarkupDocBuilder;
import io.swagger.models.properties.AbstractNumericProperty;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BaseIntegerProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.models.properties.UUIDProperty;
import io.swagger.models.refs.RefFormat;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertyAdapter {
    private final Property property;
    private static Logger logger = LoggerFactory.getLogger(PropertyAdapter.class);

    public PropertyAdapter(Property property) {
        Validate.notNull(property, "property must not be null", new Object[0]);
        this.property = property;
    }

    public static Object generateExample(Property property, MarkupDocBuilder markupDocBuilder) {
        switch (property.getType()) {
            case "integer": {
                return 0;
            }
            case "number": {
                return 0.0;
            }
            case "boolean": {
                return true;
            }
            case "string": {
                return "string";
            }
            case "ref": {
                if (property instanceof RefProperty) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("generateExample RefProperty for " + property.getName());
                    }
                    return markupDocBuilder.copy(false).crossReference(((RefProperty)property).getSimpleRef()).toString();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("generateExample for ref not RefProperty");
                }
            }
            case "array": {
                if (!(property instanceof ArrayProperty)) break;
                return PropertyAdapter.generateArrayExample((ArrayProperty)property, markupDocBuilder);
            }
        }
        return property.getType();
    }

    private static Object generateArrayExample(ArrayProperty property, MarkupDocBuilder markupDocBuilder) {
        Property itemProperty = property.getItems();
        ArrayList<Object> exampleArray = new ArrayList<Object>();
        exampleArray.add(PropertyAdapter.generateExample(itemProperty, markupDocBuilder));
        return exampleArray;
    }

    public static Object convertExample(String value, String type) {
        if (value == null) {
            return null;
        }
        try {
            switch (type) {
                case "integer": {
                    return Integer.valueOf(value);
                }
                case "number": {
                    return Float.valueOf(value);
                }
                case "boolean": {
                    return Boolean.valueOf(value);
                }
                case "string": {
                    return value;
                }
            }
            return value;
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(String.format("Value '%s' cannot be converted to '%s'", value, type), e);
        }
    }

    public Type getType(DocumentResolver definitionDocumentResolver) {
        Type type;
        if (this.property instanceof RefProperty) {
            RefProperty refProperty = (RefProperty)this.property;
            type = refProperty.getRefFormat() == RefFormat.RELATIVE ? new ObjectType(refProperty.getTitle(), null) : new RefType((String)definitionDocumentResolver.apply(refProperty.getSimpleRef()), new ObjectType(refProperty.getSimpleRef(), null));
        } else if (this.property instanceof ArrayProperty) {
            Type arrayType;
            ArrayProperty arrayProperty = (ArrayProperty)this.property;
            Property items = arrayProperty.getItems();
            type = items == null ? new ArrayType(arrayProperty.getTitle(), new ObjectType(null, null)) : ((arrayType = new PropertyAdapter(items).getType(definitionDocumentResolver)) == null ? new ArrayType(arrayProperty.getTitle(), new ObjectType(null, null)) : new ArrayType(arrayProperty.getTitle(), new PropertyAdapter(items).getType(definitionDocumentResolver)));
        } else if (this.property instanceof MapProperty) {
            MapProperty mapProperty = (MapProperty)this.property;
            Property additionalProperties = mapProperty.getAdditionalProperties();
            type = additionalProperties == null ? new MapType(mapProperty.getTitle(), new ObjectType(null, null)) : new MapType(mapProperty.getTitle(), new PropertyAdapter(additionalProperties).getType(definitionDocumentResolver));
        } else if (this.property instanceof StringProperty) {
            StringProperty stringProperty = (StringProperty)this.property;
            List<String> enums = stringProperty.getEnum();
            type = CollectionUtils.isNotEmpty(enums) ? new EnumType(stringProperty.getTitle(), enums) : (StringUtils.isNotBlank(stringProperty.getFormat()) ? new BasicType(stringProperty.getType(), stringProperty.getTitle(), stringProperty.getFormat()) : new BasicType(stringProperty.getType(), stringProperty.getTitle()));
        } else if (this.property instanceof ObjectProperty) {
            type = new ObjectType(this.property.getTitle(), ((ObjectProperty)this.property).getProperties());
        } else {
            if (this.property.getType() == null) {
                return null;
            }
            type = StringUtils.isNotBlank(this.property.getFormat()) ? new BasicType(this.property.getType(), this.property.getTitle(), this.property.getFormat()) : new BasicType(this.property.getType(), this.property.getTitle());
        }
        return type;
    }

    public Optional<Object> getDefaultValue() {
        if (this.property instanceof BooleanProperty) {
            BooleanProperty booleanProperty = (BooleanProperty)this.property;
            return Optional.ofNullable(booleanProperty.getDefault());
        }
        if (this.property instanceof StringProperty) {
            StringProperty stringProperty = (StringProperty)this.property;
            return Optional.ofNullable(stringProperty.getDefault());
        }
        if (this.property instanceof DoubleProperty) {
            DoubleProperty doubleProperty = (DoubleProperty)this.property;
            return Optional.ofNullable(doubleProperty.getDefault());
        }
        if (this.property instanceof FloatProperty) {
            FloatProperty floatProperty = (FloatProperty)this.property;
            return Optional.ofNullable(floatProperty.getDefault());
        }
        if (this.property instanceof IntegerProperty) {
            IntegerProperty integerProperty = (IntegerProperty)this.property;
            return Optional.ofNullable(integerProperty.getDefault());
        }
        if (this.property instanceof LongProperty) {
            LongProperty longProperty = (LongProperty)this.property;
            return Optional.ofNullable(longProperty.getDefault());
        }
        if (this.property instanceof UUIDProperty) {
            UUIDProperty uuidProperty = (UUIDProperty)this.property;
            return Optional.ofNullable(uuidProperty.getDefault());
        }
        return Optional.empty();
    }

    public Optional<Integer> getMinlength() {
        if (this.property instanceof StringProperty) {
            StringProperty stringProperty = (StringProperty)this.property;
            return Optional.ofNullable(stringProperty.getMinLength());
        }
        if (this.property instanceof UUIDProperty) {
            UUIDProperty uuidProperty = (UUIDProperty)this.property;
            return Optional.ofNullable(uuidProperty.getMinLength());
        }
        return Optional.empty();
    }

    public Optional<Integer> getMaxlength() {
        if (this.property instanceof StringProperty) {
            StringProperty stringProperty = (StringProperty)this.property;
            return Optional.ofNullable(stringProperty.getMaxLength());
        }
        if (this.property instanceof UUIDProperty) {
            UUIDProperty uuidProperty = (UUIDProperty)this.property;
            return Optional.ofNullable(uuidProperty.getMaxLength());
        }
        return Optional.empty();
    }

    public Optional<String> getPattern() {
        if (this.property instanceof StringProperty) {
            StringProperty stringProperty = (StringProperty)this.property;
            return Optional.ofNullable(stringProperty.getPattern());
        }
        if (this.property instanceof UUIDProperty) {
            UUIDProperty uuidProperty = (UUIDProperty)this.property;
            return Optional.ofNullable(uuidProperty.getPattern());
        }
        return Optional.empty();
    }

    public Optional<BigDecimal> getMin() {
        if (this.property instanceof BaseIntegerProperty) {
            BaseIntegerProperty integerProperty = (BaseIntegerProperty)this.property;
            return Optional.ofNullable(integerProperty.getMinimum() != null ? integerProperty.getMinimum() : null);
        }
        if (this.property instanceof AbstractNumericProperty) {
            AbstractNumericProperty numericProperty = (AbstractNumericProperty)this.property;
            return Optional.ofNullable(numericProperty.getMinimum());
        }
        return Optional.empty();
    }

    public boolean getExclusiveMin() {
        if (this.property instanceof AbstractNumericProperty) {
            AbstractNumericProperty numericProperty = (AbstractNumericProperty)this.property;
            return BooleanUtils.isTrue(numericProperty.getExclusiveMinimum());
        }
        return false;
    }

    public Optional<BigDecimal> getMax() {
        if (this.property instanceof BaseIntegerProperty) {
            BaseIntegerProperty integerProperty = (BaseIntegerProperty)this.property;
            return Optional.ofNullable(integerProperty.getMaximum() != null ? integerProperty.getMaximum() : null);
        }
        if (this.property instanceof AbstractNumericProperty) {
            AbstractNumericProperty numericProperty = (AbstractNumericProperty)this.property;
            return Optional.ofNullable(numericProperty.getMaximum());
        }
        return Optional.empty();
    }

    public boolean getExclusiveMax() {
        if (this.property instanceof AbstractNumericProperty) {
            AbstractNumericProperty numericProperty = (AbstractNumericProperty)this.property;
            return BooleanUtils.isTrue(numericProperty.getExclusiveMaximum());
        }
        return false;
    }

    public Optional<Object> getExample(boolean generateMissingExamples, MarkupDocBuilder markupDocBuilder) {
        if (this.property.getExample() != null) {
            return Optional.ofNullable(this.property.getExample());
        }
        if (this.property instanceof MapProperty) {
            Property additionalProperty = ((MapProperty)this.property).getAdditionalProperties();
            if (additionalProperty.getExample() != null) {
                return Optional.ofNullable(additionalProperty.getExample());
            }
            if (generateMissingExamples) {
                HashMap<String, Object> exampleMap = new HashMap<String, Object>();
                exampleMap.put("string", PropertyAdapter.generateExample(additionalProperty, markupDocBuilder));
                return Optional.of(exampleMap);
            }
        } else if (this.property instanceof ArrayProperty) {
            if (generateMissingExamples) {
                Property itemProperty = ((ArrayProperty)this.property).getItems();
                ArrayList<Object> exampleArray = new ArrayList<Object>();
                exampleArray.add(PropertyAdapter.generateExample(itemProperty, markupDocBuilder));
                return Optional.of(exampleArray);
            }
        } else if (generateMissingExamples) {
            return Optional.of(PropertyAdapter.generateExample(this.property, markupDocBuilder));
        }
        return Optional.empty();
    }

    public boolean getReadOnly() {
        return BooleanUtils.isTrue(this.property.getReadOnly());
    }
}

