/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.internal.adapter;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.github.swagger2markup.Swagger2MarkupConfig;
import io.github.swagger2markup.Swagger2MarkupConverter;
import io.github.swagger2markup.internal.adapter.PropertyAdapter;
import io.github.swagger2markup.internal.resolver.DocumentResolver;
import io.github.swagger2markup.internal.type.ArrayType;
import io.github.swagger2markup.internal.type.BasicType;
import io.github.swagger2markup.internal.type.EnumType;
import io.github.swagger2markup.internal.type.ObjectType;
import io.github.swagger2markup.internal.type.RefType;
import io.github.swagger2markup.internal.type.Type;
import io.github.swagger2markup.internal.utils.InlineSchemaUtils;
import io.github.swagger2markup.internal.utils.MarkupDocBuilderUtils;
import io.github.swagger2markup.internal.utils.ModelUtils;
import io.github.swagger2markup.markup.builder.MarkupDocBuilder;
import io.github.swagger2markup.model.PathOperation;
import io.swagger.models.Model;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.RefParameter;
import io.swagger.util.Json;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.WordUtils;

public class ParameterAdapter {
    private final Parameter parameter;
    private final List<ObjectType> inlineDefinitions = new ArrayList<ObjectType>();
    private final Swagger2MarkupConfig config;
    private Type type;

    public ParameterAdapter(Swagger2MarkupConverter.Context context, PathOperation operation, Parameter parameter, DocumentResolver definitionDocumentResolver) {
        Validate.notNull(parameter, "parameter must not be null", new Object[0]);
        this.parameter = parameter;
        this.type = this.getType(context.getSwagger().getDefinitions(), definitionDocumentResolver);
        this.config = context.getConfig();
        if (this.config.isInlineSchemaEnabled()) {
            if (this.config.isFlatBodyEnabled()) {
                if (!(this.type instanceof ObjectType)) {
                    this.type = InlineSchemaUtils.createInlineType(this.type, parameter.getName(), operation.getId() + " " + parameter.getName(), this.inlineDefinitions);
                }
            } else {
                this.type = InlineSchemaUtils.createInlineType(this.type, parameter.getName(), operation.getId() + " " + parameter.getName(), this.inlineDefinitions);
            }
        }
    }

    public static Object generateExample(AbstractSerializableParameter parameter) {
        switch (parameter.getType()) {
            case "integer": {
                return 0;
            }
            case "number": {
                return 0.0;
            }
            case "boolean": {
                return true;
            }
            case "string": {
                return "string";
            }
        }
        return parameter.getType();
    }

    @JsonIgnore
    public String getAccess() {
        return this.parameter.getAccess();
    }

    public String getName() {
        return this.parameter.getName();
    }

    public String getUniqueName() {
        return this.type.getUniqueName();
    }

    public String displaySchema(MarkupDocBuilder docBuilder) {
        return this.type.displaySchema(docBuilder);
    }

    public String displayDefaultValue(MarkupDocBuilder docBuilder) {
        return this.getDefaultValue().map(value -> MarkupDocBuilderUtils.literalText(docBuilder, Json.pretty(value))).orElse("");
    }

    public String displayDescription(MarkupDocBuilder markupDocBuilder) {
        return MarkupDocBuilderUtils.markupDescription(this.config.getSwaggerMarkupLanguage(), markupDocBuilder, this.getDescription());
    }

    public String displayType(MarkupDocBuilder markupDocBuilder) {
        return MarkupDocBuilderUtils.boldText(markupDocBuilder, this.getIn());
    }

    public String getDescription() {
        return this.parameter.getDescription();
    }

    public boolean getRequired() {
        return this.parameter.getRequired();
    }

    public String getPattern() {
        return this.parameter.getPattern();
    }

    public Map<String, Object> getVendorExtensions() {
        return this.parameter.getVendorExtensions();
    }

    public String getIn() {
        return WordUtils.capitalize(this.parameter.getIn());
    }

    public Type getType() {
        return this.type;
    }

    public List<ObjectType> getInlineDefinitions() {
        return this.inlineDefinitions;
    }

    private Type getType(Map<String, Model> definitions, DocumentResolver definitionDocumentResolver) {
        Validate.notNull(this.parameter, "parameter must not be null!", new Object[0]);
        Type type = null;
        if (this.parameter instanceof BodyParameter) {
            BodyParameter bodyParameter = (BodyParameter)this.parameter;
            Model model = bodyParameter.getSchema();
            type = model != null ? ModelUtils.getType(model, definitions, definitionDocumentResolver) : new BasicType("string", bodyParameter.getName());
        } else if (this.parameter instanceof AbstractSerializableParameter) {
            AbstractSerializableParameter serializableParameter = (AbstractSerializableParameter)this.parameter;
            List<String> enums = serializableParameter.getEnum();
            type = CollectionUtils.isNotEmpty(enums) ? new EnumType(serializableParameter.getName(), enums) : new BasicType(serializableParameter.getType(), serializableParameter.getName(), serializableParameter.getFormat());
            if (serializableParameter.getType().equals("array")) {
                String collectionFormat = serializableParameter.getCollectionFormat();
                type = new ArrayType(serializableParameter.getName(), new PropertyAdapter(serializableParameter.getItems()).getType(definitionDocumentResolver), collectionFormat);
            }
        } else if (this.parameter instanceof RefParameter) {
            String refName = ((RefParameter)this.parameter).getSimpleRef();
            type = new RefType((String)definitionDocumentResolver.apply(refName), new ObjectType(refName, null));
        }
        return type;
    }

    public Optional<Object> getDefaultValue() {
        Validate.notNull(this.parameter, "parameter must not be null!", new Object[0]);
        if (this.parameter instanceof AbstractSerializableParameter) {
            AbstractSerializableParameter serializableParameter = (AbstractSerializableParameter)this.parameter;
            return Optional.ofNullable(serializableParameter.getDefaultValue());
        }
        return Optional.empty();
    }
}

