/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup;

import io.github.swagger2markup.Labels;
import io.github.swagger2markup.Swagger2MarkupConfig;
import io.github.swagger2markup.Swagger2MarkupExtensionRegistry;
import io.github.swagger2markup.builder.Swagger2MarkupConfigBuilder;
import io.github.swagger2markup.builder.Swagger2MarkupExtensionRegistryBuilder;
import io.github.swagger2markup.internal.document.DefinitionsDocument;
import io.github.swagger2markup.internal.document.OverviewDocument;
import io.github.swagger2markup.internal.document.PathsDocument;
import io.github.swagger2markup.internal.document.SecurityDocument;
import io.github.swagger2markup.markup.builder.MarkupDocBuilder;
import io.github.swagger2markup.markup.builder.MarkupDocBuilders;
import io.github.swagger2markup.utils.URIUtils;
import io.swagger.models.Swagger;
import io.swagger.parser.SwaggerParser;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;

public class Swagger2MarkupConverter {
    private final Context context;
    private final OverviewDocument overviewDocument;
    private final PathsDocument pathsDocument;
    private final DefinitionsDocument definitionsDocument;
    private final SecurityDocument securityDocument;

    public Swagger2MarkupConverter(Context context) {
        this.context = context;
        this.overviewDocument = new OverviewDocument(context);
        this.pathsDocument = new PathsDocument(context);
        this.definitionsDocument = new DefinitionsDocument(context);
        this.securityDocument = new SecurityDocument(context);
    }

    public static Builder from(URI swaggerUri) {
        Validate.notNull(swaggerUri, "swaggerUri must not be null", new Object[0]);
        String scheme = swaggerUri.getScheme();
        if (scheme != null && swaggerUri.getScheme().startsWith("http")) {
            try {
                return Swagger2MarkupConverter.from(swaggerUri.toURL());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Failed to convert URI to URL", e);
            }
        }
        if (scheme != null && swaggerUri.getScheme().startsWith("file")) {
            return Swagger2MarkupConverter.from(Paths.get(swaggerUri));
        }
        return Swagger2MarkupConverter.from(URIUtils.convertUriWithoutSchemeToFileScheme(swaggerUri));
    }

    public static Builder from(URL swaggerURL) {
        Validate.notNull(swaggerURL, "swaggerURL must not be null", new Object[0]);
        return new Builder(swaggerURL);
    }

    public static Builder from(Path swaggerPath) {
        Validate.notNull(swaggerPath, "swaggerPath must not be null", new Object[0]);
        if (Files.notExists(swaggerPath, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("swaggerPath does not exist: %s", swaggerPath));
        }
        try {
            if (Files.isHidden(swaggerPath)) {
                throw new IllegalArgumentException("swaggerPath must not be a hidden file");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to check if swaggerPath is a hidden file", e);
        }
        return new Builder(swaggerPath);
    }

    public static Builder from(Swagger swagger) {
        Validate.notNull(swagger, "swagger must not be null", new Object[0]);
        return new Builder(swagger);
    }

    public static Builder from(String swaggerString) {
        Validate.notEmpty(swaggerString, "swaggerString must not be null", new Object[0]);
        return Swagger2MarkupConverter.from(new StringReader(swaggerString));
    }

    public static Builder from(Reader swaggerReader) {
        Swagger swagger;
        Validate.notNull(swaggerReader, "swaggerReader must not be null", new Object[0]);
        try {
            swagger = new SwaggerParser().parse(IOUtils.toString(swaggerReader));
        }
        catch (IOException e) {
            throw new RuntimeException("Swagger source can not be parsed", e);
        }
        if (swagger == null) {
            throw new IllegalArgumentException("Swagger source is in a wrong format");
        }
        return new Builder(swagger);
    }

    public Context getContext() {
        return this.context;
    }

    public void toFolder(Path outputDirectory) {
        Validate.notNull(outputDirectory, "outputDirectory must not be null", new Object[0]);
        this.context.setOutputPath(outputDirectory);
        this.applyOverviewDocument().writeToFile(outputDirectory.resolve(this.context.config.getOverviewDocument()), StandardCharsets.UTF_8, new OpenOption[0]);
        this.applyPathsDocument().writeToFile(outputDirectory.resolve(this.context.config.getPathsDocument()), StandardCharsets.UTF_8, new OpenOption[0]);
        this.applyDefinitionsDocument().writeToFile(outputDirectory.resolve(this.context.config.getDefinitionsDocument()), StandardCharsets.UTF_8, new OpenOption[0]);
        this.applySecurityDocument().writeToFile(outputDirectory.resolve(this.context.config.getSecurityDocument()), StandardCharsets.UTF_8, new OpenOption[0]);
    }

    private MarkupDocBuilder applyOverviewDocument() {
        return this.overviewDocument.apply(this.context.createMarkupDocBuilder(), OverviewDocument.parameters(this.context.getSwagger()));
    }

    private MarkupDocBuilder applyPathsDocument() {
        return this.pathsDocument.apply(this.context.createMarkupDocBuilder(), PathsDocument.parameters(this.context.getSwagger().getPaths()));
    }

    private MarkupDocBuilder applyDefinitionsDocument() {
        return this.definitionsDocument.apply(this.context.createMarkupDocBuilder(), DefinitionsDocument.parameters(this.context.getSwagger().getDefinitions()));
    }

    private MarkupDocBuilder applySecurityDocument() {
        return this.securityDocument.apply(this.context.createMarkupDocBuilder(), SecurityDocument.parameters(this.context.getSwagger().getSecurityDefinitions()));
    }

    public void toPath(Path outputPath) {
        Validate.notNull(outputPath, "outputPath must not be null", new Object[0]);
        if (Files.isDirectory(outputPath, new LinkOption[0])) {
            this.toFolder(outputPath);
        } else {
            this.toFile(outputPath);
        }
    }

    public void toFile(Path outputFile) {
        Validate.notNull(outputFile, "outputFile must not be null", new Object[0]);
        this.applyOverviewDocument().writeToFile(outputFile, StandardCharsets.UTF_8, new OpenOption[0]);
        this.applyPathsDocument().writeToFile(outputFile, StandardCharsets.UTF_8, StandardOpenOption.APPEND);
        this.applyDefinitionsDocument().writeToFile(outputFile, StandardCharsets.UTF_8, StandardOpenOption.APPEND);
        this.applySecurityDocument().writeToFile(outputFile, StandardCharsets.UTF_8, StandardOpenOption.APPEND);
    }

    public void toFileWithoutExtension(Path outputFile) {
        Validate.notNull(outputFile, "outputFile must not be null", new Object[0]);
        this.applyOverviewDocument().writeToFileWithoutExtension(outputFile, StandardCharsets.UTF_8, new OpenOption[0]);
        this.applyPathsDocument().writeToFileWithoutExtension(outputFile, StandardCharsets.UTF_8, StandardOpenOption.APPEND);
        this.applyDefinitionsDocument().writeToFileWithoutExtension(outputFile, StandardCharsets.UTF_8, StandardOpenOption.APPEND);
        this.applySecurityDocument().writeToFileWithoutExtension(outputFile, StandardCharsets.UTF_8, StandardOpenOption.APPEND);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.applyOverviewDocument().toString());
        sb.append(this.applyPathsDocument().toString());
        sb.append(this.applyDefinitionsDocument().toString());
        sb.append(this.applySecurityDocument().toString());
        return sb.toString();
    }

    public static class Context {
        private final Swagger2MarkupConfig config;
        private final Swagger swagger;
        private final URI swaggerLocation;
        private final Swagger2MarkupExtensionRegistry extensionRegistry;
        private final Labels labels;
        private Path outputPath;

        public Context(Swagger2MarkupConfig config, Swagger2MarkupExtensionRegistry extensionRegistry, Swagger swagger, URI swaggerLocation) {
            this.config = config;
            this.extensionRegistry = extensionRegistry;
            this.swagger = swagger;
            this.swaggerLocation = swaggerLocation;
            this.labels = new Labels(config);
        }

        public Swagger2MarkupConfig getConfig() {
            return this.config;
        }

        public Swagger getSwagger() {
            return this.swagger;
        }

        public URI getSwaggerLocation() {
            return this.swaggerLocation;
        }

        public Swagger2MarkupExtensionRegistry getExtensionRegistry() {
            return this.extensionRegistry;
        }

        public Labels getLabels() {
            return this.labels;
        }

        public MarkupDocBuilder createMarkupDocBuilder() {
            return MarkupDocBuilders.documentBuilder(this.config.getMarkupLanguage(), this.config.getLineSeparator()).withAnchorPrefix(this.config.getAnchorPrefix());
        }

        public Path getOutputPath() {
            return this.outputPath;
        }

        public void setOutputPath(Path outputPath) {
            this.outputPath = outputPath;
        }
    }

    public static class Builder {
        private final Swagger swagger;
        private final URI swaggerLocation;
        private Swagger2MarkupConfig config;
        private Swagger2MarkupExtensionRegistry extensionRegistry;

        Builder(URL swaggerUrl) {
            try {
                this.swaggerLocation = swaggerUrl.toURI();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("swaggerURL is in a wrong format", e);
            }
            this.swagger = this.readSwagger(swaggerUrl.toString());
        }

        Builder(Path swaggerPath) {
            this.swaggerLocation = swaggerPath.toAbsolutePath().toUri();
            this.swagger = this.readSwagger(swaggerPath.toString());
        }

        Builder(Swagger swagger) {
            this.swagger = swagger;
            this.swaggerLocation = null;
        }

        private Swagger readSwagger(String swaggerLocation) {
            Swagger swagger = new SwaggerParser().read(swaggerLocation);
            if (swagger == null) {
                throw new IllegalArgumentException("Failed to read the Swagger source");
            }
            return swagger;
        }

        public Builder withConfig(Swagger2MarkupConfig config) {
            Validate.notNull(config, "config must not be null", new Object[0]);
            this.config = config;
            return this;
        }

        public Builder withExtensionRegistry(Swagger2MarkupExtensionRegistry registry) {
            Validate.notNull(registry, "registry must not be null", new Object[0]);
            this.extensionRegistry = registry;
            return this;
        }

        public Swagger2MarkupConverter build() {
            if (this.config == null) {
                this.config = new Swagger2MarkupConfigBuilder().build();
            }
            if (this.extensionRegistry == null) {
                this.extensionRegistry = new Swagger2MarkupExtensionRegistryBuilder().build();
            }
            Context context = new Context(this.config, this.extensionRegistry, this.swagger, this.swaggerLocation);
            this.initExtensions(context);
            this.applySwaggerExtensions(context);
            return new Swagger2MarkupConverter(context);
        }

        private void initExtensions(Context context) {
            this.extensionRegistry.getSwaggerModelExtensions().forEach(extension -> extension.setGlobalContext(context));
            this.extensionRegistry.getOverviewDocumentExtensions().forEach(extension -> extension.setGlobalContext(context));
            this.extensionRegistry.getDefinitionsDocumentExtensions().forEach(extension -> extension.setGlobalContext(context));
            this.extensionRegistry.getPathsDocumentExtensions().forEach(extension -> extension.setGlobalContext(context));
            this.extensionRegistry.getSecurityDocumentExtensions().forEach(extension -> extension.setGlobalContext(context));
        }

        private void applySwaggerExtensions(Context context) {
            this.extensionRegistry.getSwaggerModelExtensions().forEach(extension -> extension.apply(context.getSwagger()));
        }
    }
}

